/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.sdk.kingscript.debug.cache.expiring.ExpiringCache;
import kd.sdk.kingscript.debug.callchain.DebugCallSpan;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.util.Tuple;

final class LocalDebugInfoRegistry
implements DebugInfoRegistry {
    private static final char scriptPathKeyDelim = '\b';
    private static final ExpiringCache disabledDebugIdSet = ExpiringCache.createLocal(1L, TimeUnit.DAYS).setRemovalListener((key, value, removalCause) -> Logs.getLogger().info("[LocalDebugInfoRegistry] DisabledDebugId " + key + " was removed, cause is " + (Object)((Object)removalCause) + "."));
    private Map<String, String> scriptPathMap = new ConcurrentHashMap<String, String>();
    private Map<String, DebugInfo> debugInfoMap = new ConcurrentHashMap<String, DebugInfo>();
    private Set<String> keepAliveDebugIdSet = new ConcurrentSkipListSet<String>();

    LocalDebugInfoRegistry() {
    }

    private DebugInfo getDebugInfo(String debugId) {
        DebugInfo debugInfo = this.debugInfoMap.get(debugId);
        if (debugInfo == null) {
            debugInfo = this.debugInfoMap.computeIfAbsent(debugId, k -> new DebugInfo(debugId));
        }
        return debugInfo;
    }

    private String genKey(String enginePoolName, String scriptPath, String sessionId) {
        return enginePoolName + '\b' + ScriptPathFormat.format(scriptPath) + '\b' + sessionId;
    }

    @Override
    public void register(String debugId, String[] scriptPaths, String enginePoolName, String sessionId, String userName) {
        this.getDebugInfo((String)debugId).userName = userName;
        for (String scriptPath : scriptPaths) {
            String key = this.genKey(enginePoolName, scriptPath, sessionId);
            this.scriptPathMap.put(key, debugId);
        }
    }

    @Override
    public boolean hasRegistered(String debugId) {
        return this.scriptPathMap.values().contains(debugId);
    }

    @Override
    public void setEnv(String debugId, Map<String, String> env) {
        Map<String, String> map = this.getDebugInfo((String)debugId).env;
        map.clear();
        map.putAll(env);
    }

    @Override
    public Map<String, String> getEnv(String debugId) {
        return Collections.unmodifiableMap(this.getDebugInfo((String)debugId).env);
    }

    @Override
    public String findDebugId(String scriptPath, String enginePoolName, String sessionId) {
        String key = this.genKey(enginePoolName, scriptPath, sessionId);
        return this.scriptPathMap.get(key);
    }

    @Override
    public String getDebuggingInfo(String scriptPath) {
        scriptPath = ScriptPathFormat.format(scriptPath);
        for (DebugInfo di : new ArrayList<DebugInfo>(this.debugInfoMap.values())) {
            if (!di.scriptPathIdMap.containsKey(scriptPath) || this.isDisabled(di.debugId)) continue;
            return "Current debugging user: " + di.userName;
        }
        return null;
    }

    @Override
    public String findEnginePoolName(String debugId) {
        String key = null;
        for (Map.Entry<String, String> item : this.scriptPathMap.entrySet()) {
            if (!item.getValue().equals(debugId)) continue;
            key = item.getKey();
            break;
        }
        if (key != null) {
            return key.substring(0, key.indexOf(8));
        }
        return null;
    }

    @Override
    public int incRequestEngineRound(String debugId) {
        return this.getDebugInfo((String)debugId).requestEngineRound.incrementAndGet();
    }

    @Override
    public int getRequestEngineRound(String debugId) {
        return this.getDebugInfo((String)debugId).requestEngineRound.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThenAddReplayMessage(String debugId, String method, String requestMessage) {
        List<Tuple<String, String>> list;
        this.removeReplayMessage(debugId, method);
        List<Tuple<String, String>> list2 = list = this.getDebugInfo((String)debugId).replayMessageList;
        synchronized (list2) {
            list.add(new Tuple<String, String>(method, requestMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReplayMessage(String debugId, String method) {
        List<Tuple<String, String>> list;
        List<Tuple<String, String>> list2 = list = this.getDebugInfo((String)debugId).replayMessageList;
        synchronized (list2) {
            int i = 0;
            for (Tuple<String, String> tuple : new ArrayList<Tuple<String, String>>(list)) {
                if (tuple.getKey().equals(method)) {
                    list.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getReplayMessageList(String debugId) {
        List<Tuple<String, String>> list;
        List<Tuple<String, String>> list2 = list = this.getDebugInfo((String)debugId).replayMessageList;
        synchronized (list2) {
            ArrayList<String> ret = new ArrayList<String>();
            for (Tuple<String, String> tuple : new ArrayList<Tuple<String, String>>(list)) {
                ret.add(tuple.getValue());
            }
            return ret;
        }
    }

    @Override
    public long nextSID(String debugId) {
        return this.getDebugInfo((String)debugId).nextSID.incrementAndGet();
    }

    @Override
    public void setSID(String debugId, long sid) {
        this.getDebugInfo((String)debugId).nextSID.set(sid);
    }

    @Override
    public void setRuntimeExecutionContextId(String debugId, long contextId) {
        this.getDebugInfo((String)debugId).contextId = contextId;
    }

    @Override
    public long getRuntimeExecutionContextId(String debugId) {
        return this.getDebugInfo((String)debugId).contextId;
    }

    @Override
    public void removeRuntimeExecutionContextId(String debugId) {
        this.getDebugInfo((String)debugId).contextId = 0L;
    }

    @Override
    public void setScriptId(String debugId, String scriptPath, String scriptId) {
        this.getDebugInfo((String)debugId).scriptPathIdMap.put(scriptPath, scriptId);
    }

    @Override
    public String getScriptId(String debugId, String scriptPath) {
        return this.getDebugInfo((String)debugId).scriptPathIdMap.get(scriptPath);
    }

    @Override
    public String getScriptPath(String debugId, String scriptId) {
        for (Map.Entry<String, String> item : this.getDebugInfo((String)debugId).scriptPathIdMap.entrySet()) {
            if (!item.getValue().equals(scriptId)) continue;
            return item.getKey();
        }
        return null;
    }

    @Override
    public void unRegister(String debugId) {
        String key = null;
        for (Map.Entry<String, String> item : this.scriptPathMap.entrySet()) {
            if (!item.getValue().equals(debugId)) continue;
            key = item.getKey();
            break;
        }
        if (key != null) {
            this.scriptPathMap.remove(key);
        }
        this.debugInfoMap.remove(debugId);
        this.keepAliveDebugIdSet.remove(debugId);
    }

    @Override
    public boolean isDisabled(String debugId) {
        return disabledDebugIdSet.containsKey(debugId);
    }

    @Override
    public void setDisable(String debugId) {
        disabledDebugIdSet.set(debugId, System.currentTimeMillis());
    }

    @Override
    public boolean isEchoCommand(String debugId) {
        return this.getDebugInfo((String)debugId).echoCommand;
    }

    @Override
    public void setEchoCommand(String debugId, boolean echo) {
        this.getDebugInfo((String)debugId).echoCommand = echo;
    }

    @Override
    public void addDebugCallSpan(String debugId, DebugCallSpan span) {
        this.getDebugInfo((String)debugId).callSpanList.add(span);
    }

    @Override
    public List<DebugCallSpan> getDebugCallSpanList(String debugId) {
        return new ArrayList<DebugCallSpan>(this.getDebugInfo((String)debugId).callSpanList);
    }

    @Override
    public Tuple<Long, Long> getKeepAlive(String debugId) {
        return this.getDebugInfo((String)debugId).keepAlive;
    }

    @Override
    public void setKeepAlive(String debugId, Tuple<Long, Long> keepAlive) {
        this.getDebugInfo((String)debugId).keepAlive = keepAlive;
        this.keepAliveDebugIdSet.add(debugId);
    }

    @Override
    public List<String> getKeepAliveDebugIdList() {
        return new ArrayList<String>(this.keepAliveDebugIdSet);
    }

    @Override
    public void removeKeepAlive(String debugId) {
        this.keepAliveDebugIdSet.remove(debugId);
    }

    private static class DebugInfo {
        final String debugId;
        String userName;
        AtomicInteger requestEngineRound = new AtomicInteger();
        AtomicLong nextSID = new AtomicLong();
        long contextId = 0L;
        Map<String, String> scriptPathIdMap = new ConcurrentHashMap<String, String>();
        List<Tuple<String, String>> replayMessageList = new ArrayList<Tuple<String, String>>(16);
        Map<String, String> env = new HashMap<String, String>();
        List<DebugCallSpan> callSpanList = new LinkedList<DebugCallSpan>();
        boolean echoCommand;
        Tuple<Long, Long> keepAlive;

        private DebugInfo(String debugId) {
            this.debugId = debugId;
        }
    }
}

