/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.remote;

import java.lang.reflect.Method;
import kd.sdk.kingscript.debug.client.DebugClient;
import kd.sdk.kingscript.debug.client.inspect.domain.Debugger;
import kd.sdk.kingscript.debug.client.inspect.domain.Runtime;
import kd.sdk.kingscript.debug.client.remote.RemoteDebugClientInvoker;
import kd.sdk.kingscript.debug.ws.protocol.PushMessageHandler;
import kd.sdk.kingscript.debug.ws.registry.WsClientRegistry;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Loggable;

public final class RemoteDebugClient
implements DebugClient,
Loggable {
    private static final String invokeTargetClassName = RemoteDebugClientInvoker.class.getName();
    private static final String endPointClassName = "kd.bos.mservice.endpoint.EndPointDispatchServiceHelper";
    private static Method endPointInvokeMethod;
    private final String debugId;
    private final String ip;

    public RemoteDebugClient(String debugId) {
        this(debugId, WsClientRegistry.get().getIp(debugId));
    }

    public RemoteDebugClient(String debugId, String ip) {
        this.debugId = debugId;
        this.ip = ip;
    }

    @Override
    public void inspect(String msg) {
        this.requestSync(msg);
    }

    public String requestSync(String msg) {
        logger.info("[" + this.debugId + "] Invoke remote(" + this.ip + ") " + "requestSync" + ": " + msg);
        return (String)this.invoke("requestSync", this.debugId, msg);
    }

    @Override
    public PushMessageHandler getPushMessageHandler() {
        throw new UnsupportedOperationException("Can't call getPushMessageHandler here!");
    }

    @Override
    public Debugger getDebugger() {
        throw new UnsupportedOperationException("Can't call getDebugger here!");
    }

    @Override
    public Runtime getRuntime() {
        throw new UnsupportedOperationException("Can't call getRuntime here!");
    }

    private <T> T invoke(String method, Object ... args) {
        try {
            if (endPointInvokeMethod == null) {
                Class<?> endPointDispatchServiceHelper = Class.forName(endPointClassName);
                for (Method m : endPointDispatchServiceHelper.getDeclaredMethods()) {
                    if (!m.getName().equals("invoke")) continue;
                    endPointInvokeMethod = m;
                    break;
                }
                if (endPointInvokeMethod == null) {
                    throw new ScriptException("kd.bos.mservice.endpoint.EndPointDispatchServiceHelper.invoke not found");
                }
            }
            return (T)endPointInvokeMethod.invoke(null, this.ip, invokeTargetClassName, method, args);
        }
        catch (Throwable e) {
            throw ScriptException.asRuntime(e);
        }
    }
}

