/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.config;

import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.engine.ModuleExports;

public final class DebugConfig {
    @ConfigurableItem(desc="\u8c03\u8bd5\u8d85\u65f6\u65f6\u95f4")
    public static final String DEBUG_TIMEOUT = "kingscript.debug.timeout";
    @ConfigurableItem(desc="\u56de\u663e\u8c03\u8bd5\u6307\u4ee4\u603b\u5f00\u5173")
    public static final String DEBUG_KDP_ECHO_COMMAND = "kingscript.debug.kdp.echoCommand";
    @ConfigurableItem(desc="\u8f93\u51fa\u539f\u59cb\u8c03\u8bd5\u6307\u4ee4")
    public static final String DEBUG_KDP_LOG_DETAIL = "kingscript.debug.kdp.logDetail";
    private static long timeout = 600000L;
    private static boolean kdpEchoCommand = true;
    private static boolean kdpLogDetail = false;

    public static long getDebugEngineKeepTime() {
        return timeout * 10L;
    }

    public static long getTimeout() {
        return timeout;
    }

    public static long getRequestCommandTimeout() {
        return timeout / 10L;
    }

    public static long getDebuggerGoOrDebuggerReadyTimeout() {
        return timeout / 2L;
    }

    public static boolean isKdpEchoCommand(String debugId) {
        return kdpEchoCommand && DebugInfoRegistry.get().isEchoCommand(debugId);
    }

    public static boolean isKdpLogDetail() {
        return kdpLogDetail;
    }

    public static boolean isDebuggable(String formattedScriptPath, boolean isConstVersionModule) {
        return !isConstVersionModule;
    }

    public static boolean isDebuggable(String formattedScriptPath) {
        return DebugConfig.isDebuggable(formattedScriptPath, ModuleExports.isConstVersionModule(formattedScriptPath));
    }

    static {
        timeout = Long.parseLong(System.getProperty(DEBUG_TIMEOUT, String.valueOf(timeout)));
        kdpEchoCommand = Boolean.valueOf(System.getProperty(DEBUG_KDP_ECHO_COMMAND, String.valueOf(kdpEchoCommand)));
        kdpLogDetail = Boolean.valueOf(System.getProperty(DEBUG_KDP_LOG_DETAIL, String.valueOf(kdpLogDetail)));
    }
}

