/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.keepalive;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.log.Loggable;
import kd.sdk.kingscript.util.Tuple;

public final class KeepAliveService
implements Loggable {
    @ConfigurableItem(desc="keep alive timeout")
    public static final String CONFIG_DEBUG_KEEP_ALIVE_TIMEOUT = "kingscript.debug.keepAliveTimeout";
    private static long keepAliveTimeout = 30000L;
    private static long checkInterval = 5000L;
    private static boolean debuggerSupportKeepAlive = true;
    private static final AtomicBoolean threadStarted = new AtomicBoolean();
    private static final AtomicInteger threadSeq = new AtomicInteger();
    private static final Object lock = new Object();

    public static long getDefaultAliveTimeout() {
        return keepAliveTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touchKeepAlive(String debugId) {
        if (debuggerSupportKeepAlive) {
            DebugInfoRegistry dir = DebugInfoRegistry.get();
            Tuple<Long, Long> tp = dir.getKeepAlive(debugId);
            if (tp == null) {
                tp = new Tuple<Long, Long>(keepAliveTimeout, KeepAliveService.genTimeoutTS(keepAliveTimeout));
            } else {
                tp.setValue(KeepAliveService.genTimeoutTS(tp.getKey()));
            }
            dir.setKeepAlive(debugId, tp);
            Object object = lock;
            synchronized (object) {
                KeepAliveService.ensureStartTimeoutChecker();
                lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKeepAlive(String debugId, long aliveTimeout) {
        DebugInfoRegistry dir;
        Tuple<Long, Long> tp;
        if (!debuggerSupportKeepAlive) {
            debuggerSupportKeepAlive = true;
        }
        if ((tp = (dir = DebugInfoRegistry.get()).getKeepAlive(debugId)) == null) {
            tp = new Tuple<Long, Long>(aliveTimeout, KeepAliveService.genTimeoutTS(aliveTimeout));
        } else {
            tp.setKey(aliveTimeout);
            tp.setValue(KeepAliveService.genTimeoutTS(aliveTimeout));
        }
        logger.info("[" + debugId + "] " + "Debugger.keepAlive" + " setKeepAlive=" + aliveTimeout);
        dir.setKeepAlive(debugId, tp);
        Object object = lock;
        synchronized (object) {
            KeepAliveService.ensureStartTimeoutChecker();
            lock.notifyAll();
        }
    }

    private static long genTimeoutTS(long timeout) {
        return System.currentTimeMillis() + timeout;
    }

    public static void remove(String debugId) {
        DebugInfoRegistry.get().removeKeepAlive(debugId);
    }

    private static void ensureStartTimeoutChecker() {
        if (threadStarted.compareAndSet(false, true)) {
            DebugInfoRegistry dir = DebugInfoRegistry.get();
            Thread th = new Thread(() -> {
                Object object = lock;
                synchronized (object) {
                    List<String> debugIdList;
                    while (!(debugIdList = dir.getKeepAliveDebugIdList()).isEmpty()) {
                        long now = System.currentTimeMillis();
                        int removed = 0;
                        for (String debugId : debugIdList) {
                            Tuple<Long, Long> tp = dir.getKeepAlive(debugId);
                            boolean timeout = tp == null || tp.getValue() < now;
                            if (!timeout) continue;
                            if (tp != null) {
                                logger.warn("[" + debugId + "] Debugger will be disable cause keep alive timeout(" + tp.getValue() + "<now): " + CONFIG_DEBUG_KEEP_ALIVE_TIMEOUT + "=" + tp.getKey());
                            }
                            ++removed;
                            DebuggerDisable.disable(debugId);
                        }
                        if (debugIdList.size() == removed) break;
                        try {
                            lock.wait(checkInterval);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    threadStarted.set(false);
                }
            });
            th.setDaemon(true);
            th.setName("KingScript-Debug-" + KeepAliveService.class.getSimpleName() + "-" + threadSeq.incrementAndGet());
            th.start();
        }
    }

    static {
        keepAliveTimeout = Long.parseLong(System.getProperty(CONFIG_DEBUG_KEEP_ALIVE_TIMEOUT, String.valueOf(keepAliveTimeout)));
    }
}

