/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.ws.protocol;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.debug.ws.protocol.PushMessageHandler;
import kd.sdk.kingscript.debug.ws.protocol.WsSocket;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.util.ThreadUtil;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;

class WsProtocol {
    protected static final Logger logger = Logs.getLogger();
    private final String debugId;
    private final String wsUrl;
    private WebSocketClient client;
    private WsSocket socket;
    private final AtomicBoolean closed = new AtomicBoolean();

    public WsProtocol(String debugId, String wsUrl, PushMessageHandler pushMessageHandler) {
        this.debugId = debugId;
        this.wsUrl = wsUrl;
        this.client = new WebSocketClient();
        long ts = DebugConfig.getTimeout();
        this.client.setMaxIdleTimeout(ts);
        this.client.setAsyncWriteTimeout(ts / 2L);
        this.client.setStopTimeout(5000L);
        this.socket = new WsSocket(pushMessageHandler);
    }

    public void connect() {
        try {
            this.client.start();
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            logger.info("[" + this.debugId + "] WebSocketClient Connecting to: " + this.wsUrl);
            this.client.connect((Object)this.socket, new URI(this.wsUrl), request);
            this.socket.awaitConnect();
        }
        catch (Throwable t) {
            throw ScriptException.asRuntime(t);
        }
    }

    public void send(String ... messages) {
        this.ensureConnect();
        this.socket.sendMessage(messages);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ThreadUtil.start(() -> {
                try {
                    logger.info("[" + this.debugId + "] WebSocketClient Closing from: " + this.wsUrl);
                    this.client.stop();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.socket.close();
                }
            });
        }
    }

    private void ensureConnect() {
        if (this.closed.get()) {
            throw new ScriptException("[" + this.debugId + "] WsProtocol closed: " + this.wsUrl);
        }
    }
}

