/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import java.util.function.Predicate;
import kd.sdk.kingscript.engine.InternalEngineFactory;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.security.AllowHostClassLookup;
import kd.sdk.kingscript.security.SecurityController;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.ResourceLimits;
import org.graalvm.polyglot.io.FileSystem;

public class ContextBuilder {
    private static final String ecmaScriptVersion = "2022";

    public static Context.Builder createTranspilerContextBuilder() {
        return Context.newBuilder((String[])new String[0]).allowHostAccess(HostAccess.ALL).allowHostClassLookup(className -> true).allowExperimentalOptions(true).allowPolyglotAccess(PolyglotAccess.ALL).allowAllAccess(true).allowHostClassLoading(true).allowIO(true).allowNativeAccess(true).useSystemExit(false).option("js.ecmascript-version", ecmaScriptVersion).option("log.level", "WARNING");
    }

    public static Context.Builder createExecutorContextBuilder(ScriptOptions options, LibFileSystem libFileSystem) {
        SecurityController securityController;
        Context.Builder ctxBuilder = Context.newBuilder((String[])new String[0]).allowExperimentalOptions(true).fileSystem((FileSystem)libFileSystem).allowPolyglotAccess(PolyglotAccess.ALL).allowHostAccess(InternalEngineFactory.getSharedHostAccess()).allowHostClassLookup((Predicate)new AllowHostClassLookup(() -> options.getCachedSecurityController())).allowCreateThread(false).allowCreateProcess(false).allowNativeAccess(false).allowIO(true).allowValueSharing(true).allowEnvironmentAccess(EnvironmentAccess.NONE).allowAllAccess(true).useSystemExit(false).option("js.strict", "false").option("js.ecmascript-version", ecmaScriptVersion).option("js.esm-eval-returns-exports", "true").option("log.level", "WARNING");
        ctxBuilder.allowExperimentalOptions(true);
        ContextBuilder.setNashornCompatibilityMode(ctxBuilder);
        ctxBuilder.options(options.getOtherOptions());
        if (options.isInteractive()) {
            ctxBuilder.option("js.shell", "true");
        }
        if ((securityController = options.getCachedSecurityController()) != null && securityController.getLimitMaxStatements() > 0L) {
            ctxBuilder.resourceLimits(ResourceLimits.newBuilder().statementLimit(securityController.getLimitMaxStatements(), source -> securityController.isLimitMaxStatements(source.getName())).build());
        }
        return ctxBuilder;
    }

    private static void setNashornCompatibilityMode(Context.Builder builder) {
        builder.option("js.nashorn-compat", "false");
    }
}

