/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.sdk.kingscript.debug.client.DebugClient;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;

public final class EvalContext
implements AutoCloseable {
    private static final ThreadLocal<EvalContext> th = new ThreadLocal();
    private final KingScriptEngineImpl engine;
    private final String scriptPath;
    private final EvalContext parent;
    private final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private final Set<String> importedSet = new HashSet<String>();

    public static EvalContext setup(KingScriptEngineImpl engine, String scriptPath) {
        return new EvalContext(engine, scriptPath);
    }

    public static EvalContext get() {
        return th.get();
    }

    private EvalContext(KingScriptEngineImpl engine, String scriptPath) {
        this.engine = engine;
        this.scriptPath = scriptPath;
        this.parent = th.get();
        th.set(this);
    }

    public boolean addImported(String path) {
        return this.importedSet.add(path);
    }

    @Override
    public void close() {
        if (this.parent == null) {
            th.remove();
        } else {
            th.set(this.parent);
        }
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public boolean isDebuggable() {
        return this.engine.isDebuggable();
    }

    public String getDebugId() {
        return this.engine.getDebugId();
    }

    public KingScriptEngineImpl getEngine() {
        return this.engine;
    }

    public void debugModeNotifyConsoleAPICalledLog(String loggerName, String level, Object[] logArgs) {
        StringBuilder sb = new StringBuilder(128).append(this.sdf.format(new Date())).append('[').append(Thread.currentThread().getName()).append(']').append(' ').append(level.toUpperCase()).append(' ').append(loggerName).append(" - ");
        int n = logArgs.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.toLogMessage(logArgs[i]));
        }
        String consoleMessage = sb.toString();
        DebugClient dc = DebugClient.getOrCreate(this.getDebugId());
        dc.getRuntime().runAsync(() -> dc.getRuntime().notifyConsoleLog(consoleMessage));
    }

    private String toLogMessage(Object logArg) {
        if (logArg instanceof Throwable) {
            Throwable e = (Throwable)logArg;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        return String.valueOf(logArg);
    }
}

