/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import com.oracle.truffle.host.HostLanguageService;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.management.ExecutionEvent;

public final class KingScriptContext {
    private static Method hostEnter;
    private static Method hostLeave;
    private static HostLanguageService notNullHostLanguageService;
    private Context ctx;
    private Object hostContext;
    private HostLanguageService hostLanguageService;
    private Map<String, Object> runtimeAttrMap = new HashMap<String, Object>();
    private ByteSeekableByteChannel lastLoaded;
    private final ReentrantLock lock = new ReentrantLock();
    private ExecutionEvent executionEvent;
    private String bizAppId;

    public static KingScriptContext get() {
        KingScriptEngineImpl impl = KingScriptEngineImpl.getCurrentEngineImpl();
        return impl == null ? null : impl.getKingScriptContext();
    }

    static KingScriptContext create(Context ctx) {
        return new KingScriptContext(ctx);
    }

    private KingScriptContext(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Object getHostContext() {
        return this.hostContext;
    }

    void setHostContext(Object hostContext) {
        this.hostContext = hostContext;
    }

    public HostLanguageService getHostLanguageService() {
        return this.hostLanguageService == null ? notNullHostLanguageService : this.hostLanguageService;
    }

    void setHostLanguageService(HostLanguageService hostLanguageService) {
        this.hostLanguageService = hostLanguageService;
        if (hostLanguageService != null) {
            notNullHostLanguageService = hostLanguageService;
        }
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Object getRuntimeAttr(String key) {
        return this.runtimeAttrMap.get(key);
    }

    public Object removeRuntimeAttr(String key) {
        return this.runtimeAttrMap.remove(key);
    }

    public void setRuntimeAttr(String key, Object value) {
        this.runtimeAttrMap.put(key, value);
    }

    public ByteSeekableByteChannel getLastLoaded() {
        return this.lastLoaded;
    }

    public void setLastLoaded(ByteSeekableByteChannel lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public String getBizAppId() {
        return this.bizAppId;
    }

    public void setBizAppId(String bizAppId) {
        this.bizAppId = bizAppId;
    }

    public Object hostEnter() {
        try {
            return hostEnter.invoke(null, this.hostContext);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public String getExecutionStatement() {
        if (this.executionEvent != null) {
            SourceSection location = this.executionEvent.getLocation();
            String fullScript = location.getSource().getCharacters().toString();
            int from = location.getStartColumn() - 2;
            int to = location.getEndLine() != location.getStartLine() ? location.getSource().getLineLength(location.getStartLine()) : location.getEndColumn() + 20;
            if (from < 0) {
                from = 0;
            }
            if (to > fullScript.length()) {
                to = fullScript.length();
            }
            String wildCode = fullScript.substring(from, to);
            if (to < fullScript.length()) {
                wildCode = wildCode + "...";
            }
            return "[" + location.getSource().getName() + '(' + location.getStartLine() + ',' + location.getStartColumn() + "): " + wildCode + "] " + location.getCharacters();
        }
        return null;
    }

    void setExecutionEvent(ExecutionEvent executionEvent) {
        this.executionEvent = executionEvent;
    }

    public void hostLeave(Object prev) {
        try {
            hostLeave.invoke(null, this.hostContext, prev);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("com.oracle.truffle.polyglot.PolyglotValueDispatch");
            hostEnter = cls.getDeclaredMethod("hostEnter", Object.class);
            hostEnter.setAccessible(true);
            hostLeave = cls.getDeclaredMethod("hostLeave", Object.class, Object.class);
            hostLeave.setAccessible(true);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }
}

