/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import com.alibaba.fastjson.JSONObject;
import com.oracle.truffle.host.HostLanguageService;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.engine.ContextBuilder;
import kd.sdk.kingscript.engine.EvalContext;
import kd.sdk.kingscript.engine.InternalEngineFactory;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.ModuleExports;
import kd.sdk.kingscript.engine.ModuleExportsManager;
import kd.sdk.kingscript.engine.ScriptInitializer;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.engine.bindings.ScriptBindings;
import kd.sdk.kingscript.engine.bindings.ScriptBindingsImpl;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.exception.ScriptSecurityException;
import kd.sdk.kingscript.global.GlobalObject;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.lib.crypto.CryptoUtil;
import kd.sdk.kingscript.lib.store.ScriptMixedStore;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.listener.EngineListener;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Collector;
import kd.sdk.kingscript.monitor.cost.Cost;
import kd.sdk.kingscript.monitor.cost.EngineCostType;
import kd.sdk.kingscript.monitor.cost.probe.ProbeContext;
import kd.sdk.kingscript.monitor.timeout.service.LevelTimeoutInterrupter;
import kd.sdk.kingscript.pool.KingScriptEnginePool;
import kd.sdk.kingscript.security.IgnoreSecurityCheck;
import kd.sdk.kingscript.security.SecurityController;
import kd.sdk.kingscript.test.ScriptAssert;
import kd.sdk.kingscript.transpiler.BabelTranspiler;
import kd.sdk.kingscript.transpiler.ScriptFeature;
import kd.sdk.kingscript.transpiler.TransResult;
import kd.sdk.kingscript.transpiler.TranspilerEvalContext;
import kd.sdk.kingscript.types.ScriptValueImpl;
import kd.sdk.kingscript.types.Types;
import kd.sdk.kingscript.types.function.Handler0;
import kd.sdk.kingscript.util.FileUtil;
import kd.sdk.kingscript.util.ThreadCollector;
import kd.sdk.kingscript.util.ThreadCollectorMaps;
import kd.sdk.kingscript.util.ThreadValueCollector;
import kd.sdk.kingscript.util.Tuple;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.management.ExecutionEvent;
import org.graalvm.polyglot.management.ExecutionListener;
import org.slf4j.Logger;

public class KingScriptEngineImpl
implements KingScriptEngine {
    private static final String evalContentSourcePathPrefix = "eval-";
    private static final AtomicInteger engineNameSeq = new AtomicInteger();
    private static final Logger logger = Logs.getLogger();
    private static final AtomicInteger evalSeq = new AtomicInteger();
    private final AtomicReference<Thread> ownThread = new AtomicReference();
    private final boolean logEnabled;
    private String preAddScript = "";
    private final GraalJSScriptEngine scriptEngine;
    private final Context context;
    private final ScriptBindingsImpl allBindings;
    private ExecutionListener executionListener;
    private final Supplier<BabelTranspiler> transpilerSupplier;
    private final boolean useSharedTranspiler;
    private BabelTranspiler internalTranspiler;
    private final KingScriptContext kingScriptContext;
    private final ScriptOptions options;
    private final LibFileSystem libFileSystem;
    private final List<EngineListener> listeners = new LinkedList<EngineListener>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String name;
    private final boolean enableTimeout;
    private LevelTimeoutInterrupter levelControlTimeoutInterrupter;
    private final boolean debug;
    private String debugUrl;
    private String debugId;
    private final JSRealm jsRealm;
    private final LinkedList<Tuple<Thread, Handler0>> leaveCallList = new LinkedList();
    private KingScriptEngine topWrapper;
    private final KingScriptEnginePool pool;

    public static KingScriptEngineImpl getCurrentEngineImpl() {
        try {
            JSRealm currentJSRealm = JavaScriptLanguage.getCurrentJSRealm();
            return (KingScriptEngineImpl)(currentJSRealm == null ? null : currentJSRealm.getKingScriptEngine());
        }
        catch (AssertionError error) {
            return null;
        }
    }

    static KingScriptEngineImpl create() {
        return new KingScriptEngineImpl(null, null, null, null);
    }

    static KingScriptEngineImpl create(ScriptInitializer initializer) {
        return new KingScriptEngineImpl(initializer, null, null, null);
    }

    public static KingScriptEngineImpl create(ScriptOptions options, Supplier<BabelTranspiler> sharedTranspilerSupplier, KingScriptEnginePool pool) {
        return new KingScriptEngineImpl(null, options, sharedTranspilerSupplier, pool);
    }

    private KingScriptEngineImpl(ScriptInitializer initializer, ScriptOptions options, Supplier<BabelTranspiler> sharedTranspilerSupplier, KingScriptEnginePool pool) {
        this.pool = pool;
        this.name = "ScriptEngine-" + engineNameSeq.incrementAndGet();
        this.setOwnThread(Thread.currentThread());
        if (options == null) {
            options = ScriptOptions.createDefault();
        }
        if (initializer != null) {
            initializer.initialize(options);
        }
        this.logEnabled = options.isLogEnabled();
        this.debug = options.getDebugOptions().isEnabled();
        try (Cost cost = Collector.cost(EngineCostType.engine_init.name(), this.name).logOnClose().warnOnClose();){
            if (this.logEnabled) {
                logger.info("init " + this.name);
            }
            this.options = options;
            this.transpilerSupplier = sharedTranspilerSupplier == null ? () -> {
                if (this.internalTranspiler == null) {
                    this.internalTranspiler = BabelTranspiler.create(this.options);
                }
                return this.internalTranspiler;
            } : sharedTranspilerSupplier;
            this.useSharedTranspiler = sharedTranspilerSupplier != null;
            ScriptStore scriptStore = options.getScriptStore();
            scriptStore = scriptStore == null ? ScriptMixedStore.wrap(ScriptStore.create()) : ScriptMixedStore.wrap(scriptStore);
            this.libFileSystem = new LibFileSystem(this::ts2js, options.getLibModules(), scriptStore, this.debug);
            ((ScriptMixedStore)scriptStore).setLibFileSystem(this.libFileSystem);
            try (ThreadCollector tc = ThreadCollector.create();){
                Context.Builder ctxBuilder = ContextBuilder.createExecutorContextBuilder(options, this.libFileSystem);
                if (this.debug) {
                    try (ThreadValueCollector tvc = ThreadValueCollector.setup();){
                        this.scriptEngine = InternalEngineFactory.createDebugEngine(ctxBuilder, options);
                        this.debugUrl = (String)tvc.getValue();
                    }
                } else {
                    this.scriptEngine = InternalEngineFactory.createSharedEngine(ctxBuilder);
                }
                this.context = this.scriptEngine.getPolyglotContext();
                this.kingScriptContext = KingScriptContext.create(this.context);
                this.kingScriptContext.setHostContext(ThreadCollectorMaps.getIfHasThreadCollector("HostContext"));
                this.kingScriptContext.setHostLanguageService((HostLanguageService)((Object)ThreadCollectorMaps.getIfHasThreadCollector("HostLanguageService")));
                this.allBindings = new ScriptBindingsImpl(this.scriptEngine);
            }
            this.jsRealm = JavaScriptLanguage.getJSRealm(this.context);
            this.jsRealm.setKingScriptEngine(this);
            GlobalObject.setupInterop(this.jsRealm, options);
            this.enter();
            try {
                var9_12 = null;
                try (IgnoreSecurityCheck isc = IgnoreSecurityCheck.setup();){
                    this.initEngineAll();
                }
                catch (Throwable throwable) {
                    var9_12 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable e2) {
                throw new ScriptException("init engine error", e2);
            }
            finally {
                this.leave();
            }
            this.executionListener = ExecutionListener.newBuilder().onEnter(e -> this.kingScriptContext.setExecutionEvent((ExecutionEvent)e)).expressions(true).attach(this.scriptEngine.getPolyglotEngine());
            SecurityController securityController = options.getCachedSecurityController();
            boolean bl = this.enableTimeout = securityController != null && securityController.isLimitScriptEvalTimeout();
            if (this.enableTimeout) {
                this.levelControlTimeoutInterrupter = LevelTimeoutInterrupter.create(this.name, this.context, this);
            }
        }
    }

    private void initEngineAll() throws javax.script.ScriptException {
        String initScriptNamePrefix = "[engine]";
        if (this.debug) {
            String tipScript = "console.log('" + this.name + " run at debug mode...')";
            this.evalInternal(tipScript, "[engine]initialize_debug.js");
        }
        ScriptAssert.setup(this);
        String initScript = FileUtil.readResource("/asset/engine/initialize_script.js");
        if (initScript.length() > 0) {
            this.evalInternal(initScript + ";undefined", "[engine]" + "/asset/engine/initialize_script.js".substring("/asset/engine/initialize_script.js".lastIndexOf(47) + 1));
        }
        if (!this.options.getTranslationOptions().getTargetVersion().isSupportEMS()) {
            String es5Default = "if(typeof exports=='undefined')exports={}";
            this.evalInternal(es5Default + ";undefined", "[engine]initialize_exports.js");
        }
        this.preAddScript = FileUtil.readResource("/asset/engine/pre_add_script.js");
        this.preheat();
    }

    private void preheat() {
        if (this.options.isPreheat()) {
            try {
                String[] scriptPaths = this.options.getPreheatScriptPaths();
                if (scriptPaths != null && scriptPaths.length > 0) {
                    for (String scriptPath : scriptPaths) {
                        this.evalPath(scriptPath);
                    }
                }
            }
            catch (Throwable e) {
                logger.warn("preheat failed: " + e.getMessage(), e);
            }
        }
    }

    public KingScriptEnginePool getPool() {
        return this.pool;
    }

    public ScriptOptions getOptions() {
        return this.options;
    }

    public String toString() {
        return this.name;
    }

    private Object evalInternal(String js, String name) throws javax.script.ScriptException {
        Source source = this.buildSource(js, null, true, true, true, name);
        return this.scriptEngine.eval2(source, this.scriptEngine.getContext());
    }

    public LibFileSystem getLibFileSystem() {
        return this.libFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enter() {
        this.checkClosed();
        LinkedList<Tuple<Thread, Handler0>> linkedList = this.leaveCallList;
        synchronized (linkedList) {
            this.context.enter();
            ProbeContext.enter();
            int level = this.leaveCallList.size();
            JSRealm currentRealm = JSRealm.get(null);
            Thread thread = Thread.currentThread();
            this.setOwnThread(thread);
            if (this.jsRealm != currentRealm) {
                JSRealm.setCurrentRealm(this.jsRealm);
                this.leaveCallList.addLast(new Tuple<Thread, Handler0>(thread, () -> {
                    if (!(this.debug || level == this.leaveCallList.size() && thread == Thread.currentThread() && JSRealm.get(null) == this.jsRealm)) {
                        throw new ScriptException("enter-leave call mismatch!");
                    }
                    JSRealm.setCurrentRealm(currentRealm);
                }));
            } else {
                this.leaveCallList.addLast(new Tuple<Thread, Handler0>(thread, () -> {
                    if (!(this.debug || level == this.leaveCallList.size() && thread == Thread.currentThread())) {
                        throw new ScriptException("enter-leave call mismatch, enter=" + thread + ", leave=" + Thread.currentThread());
                    }
                }));
            }
        }
    }

    @Override
    public final void leave() {
        this.checkClosed();
        this.doLeave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLeave() {
        LinkedList<Tuple<Thread, Handler0>> linkedList = this.leaveCallList;
        synchronized (linkedList) {
            if (!this.leaveCallList.isEmpty()) {
                IllegalStateException illegalStateException = null;
                try {
                    this.leaveCallList.removeLast().getValue().accept();
                }
                finally {
                    try {
                        ProbeContext.leave();
                    }
                    finally {
                        try {
                            this.context.leave();
                        }
                        catch (IllegalStateException e) {
                            illegalStateException = e;
                        }
                    }
                }
                if (!this.debug && illegalStateException != null) {
                    throw illegalStateException;
                }
            }
        }
    }

    private void waitLeaved() {
        if (this.debug) {
            try {
                int round = 0;
                while (this.hasOtherThreadLeaveCall() && round++ < 100) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (!this.leaveCallList.isEmpty()) {
            this.doLeave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasOtherThreadLeaveCall() {
        LinkedList<Tuple<Thread, Handler0>> linkedList = this.leaveCallList;
        synchronized (linkedList) {
            if (this.leaveCallList.isEmpty()) {
                return false;
            }
            Thread thread = Thread.currentThread();
            for (Tuple tuple : this.leaveCallList) {
                if (tuple.getKey() == thread) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ScriptBindings getBindings() {
        return this.allBindings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String load(String scriptPath) {
        this.checkClosed();
        try (ByteSeekableByteChannel bc = this.libFileSystem.newByteChannel(scriptPath);){
            if (CryptoUtil.isCryptoScript(scriptPath)) {
                String string = bc.getCompiledScript();
                return string;
            }
            String string = bc.getOriginalScript();
            return string;
        }
        catch (IOException e) {
            throw ScriptException.wrap(e);
        }
    }

    @Override
    public JSONObject loadWithVersion(String scriptPath) {
        this.checkClosed();
        JSONObject result = new JSONObject();
        try (ByteSeekableByteChannel bc = this.libFileSystem.newByteChannel(scriptPath);){
            result.put("data", (Object)(CryptoUtil.isCryptoScript(scriptPath) ? bc.getCompiledScript() : bc.getOriginalScript()));
            result.put("version", (Object)bc.getVersion());
        }
        catch (IOException e) {
            throw ScriptException.wrap(e);
        }
        return result;
    }

    @Override
    public void addListener(EngineListener el) {
        this.listeners.add(el);
    }

    @Override
    public void removeListener(EngineListener el) {
        this.listeners.remove(el);
    }

    @Override
    public List<EngineListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            return this.closed.get();
        }
    }

    @Override
    public boolean isDebuggable() {
        return this.debug;
    }

    @Override
    public String getDebugUrl() {
        return this.debugUrl;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    public KingScriptContext getKingScriptContext() {
        return this.kingScriptContext;
    }

    private void checkClosed() {
        if (this.getTopWrapper().isClosed()) {
            throw new ScriptException("Engine has closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            if (this.pool == null && !this.closed.get()) {
                this.waitForClosed();
            }
            if (this.closed.compareAndSet(false, true)) {
                if (this.logEnabled) {
                    logger.info("close " + this.name);
                }
                if (!this.useSharedTranspiler && this.internalTranspiler != null) {
                    this.internalTranspiler.close();
                }
                if (this.enableTimeout) {
                    this.levelControlTimeoutInterrupter.destroy();
                }
                if (this.executionListener != null) {
                    this.executionListener.close();
                    this.executionListener = null;
                }
                InternalEngineFactory.onClosed(this.scriptEngine.getPolyglotEngine());
                if (this.pool == null) {
                    this.fireOnClosed();
                }
                this.setTopWrapper(null);
                this.setOwnThread(null);
                this.setDebugId(null);
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return (T)(cls == this.getClass() ? this : null);
    }

    public static boolean isEvalByContent(String sourcePath) {
        return sourcePath != null && sourcePath.matches("eval-\\d+\\.(m)?js");
    }

    private Source buildSource(String js, String scriptPath, boolean interactive, boolean internal, boolean cached, String defaultName) {
        if (defaultName == null) {
            defaultName = interactive ? "<shell>" : evalContentSourcePathPrefix + evalSeq.incrementAndGet() + (this.options.getTranslationOptions().getTargetVersion().isSupportEMS() ? ".mjs" : ".js");
        }
        Source.Builder sb = Source.newBuilder((String)"js", (CharSequence)this.wrapJS(js), (String)defaultName).cached(cached).internal(internal).interactive(interactive);
        if (scriptPath != null) {
            sb.uri(URI.create(scriptPath));
        }
        try {
            return interactive ? sb.buildLiteral() : sb.build();
        }
        catch (IOException e) {
            throw ScriptException.wrap(e);
        }
    }

    private String wrapJS(String js) {
        return this.preAddScript + js;
    }

    @Override
    public String ts2js(String ts) {
        this.checkClosed();
        return this.ts2js(ts, null, null).getCode();
    }

    /*
     * Exception decompiling
     */
    private TransResult ts2js(String ts, String scriptPath, ScriptInfo scriptInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkScriptContentSecurity(TransResult trans, String scriptPath, ScriptInfo scriptInfo) {
        SecurityController securityController = this.options.getCachedSecurityController();
        if (securityController != null) {
            ScriptFeature scriptFeature = trans.getScriptFeature();
            for (Map.Entry<String, Integer> item : scriptFeature.getImportInternalPath().entrySet()) {
                String importInternalModulePath = item.getKey();
                if (securityController.allowImportInternal(scriptPath, importInternalModulePath, scriptInfo)) continue;
                String msg = "Not allow import internal module '" + importInternalModulePath + "'";
                if (scriptPath != null) {
                    msg = msg + " in " + scriptPath;
                }
                msg = msg + " @line " + item.getValue();
                throw new ScriptSecurityException(msg);
            }
            for (Map.Entry<String, Integer> item : scriptFeature.getConstructorType().entrySet()) {
                String type = item.getKey();
                if (securityController.allowUseConstructorType(scriptPath, type, scriptInfo)) continue;
                String msg = "Not allow use $.type('" + type + "')";
                if (scriptPath != null) {
                    msg = msg + " in " + scriptPath;
                }
                msg = msg + " @line " + item.getValue();
                throw new ScriptSecurityException(msg);
            }
        }
    }

    @Override
    public Object eval(String ts) {
        return this.doEval(this.ts2js(ts), null, null, null, false, "evalTS");
    }

    @Override
    public Object evalJavaScript(String js) {
        this.ts2js(js);
        return this.doEval(js, null, null, null, false, "evalJS");
    }

    @Override
    public Object evalPath(String scriptPath) {
        return this.evalPath(scriptPath, false).getValue();
    }

    @Override
    public Object evalLib(String libPath) {
        return this.evalPath(libPath, true).getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple<ByteSeekableByteChannel, Object> evalPath(String scriptPath, boolean isLib) {
        try (ByteSeekableByteChannel bc = this.libFileSystem.newByteChannel(scriptPath);){
            String name = bc.getScriptPath();
            String lwName = name.toLowerCase();
            String formattedScriptPath = ScriptPathFormat.format(bc.getScriptPath());
            int hashCode = bc.getCompiledScript().hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                hashCode = 0;
            } else if (hashCode < 0) {
                hashCode = 0 - hashCode;
            }
            String seqTag = '(' + bc.getVersion() + '_' + hashCode + ')';
            if (!isLib || this.debug && DebugConfig.isDebuggable(formattedScriptPath)) {
                seqTag = seqTag + "-" + evalSeq.incrementAndGet();
            }
            name = lwName.endsWith(".ts") || lwName.endsWith(".js") ? name.substring(0, name.length() - 3) + seqTag + ".mjs" : name + seqTag + ".mjs";
            Tuple<ByteSeekableByteChannel, Object> tuple = new Tuple<ByteSeekableByteChannel, Object>(bc, this.doEval(bc.getCompiledScript(), bc.getScriptPath(), formattedScriptPath, name, isLib, isLib ? "evalLib" : "evalPath"));
            return tuple;
        }
        catch (IOException e) {
            throw ScriptException.wrap(e);
        }
    }

    private Object doEval(String js, String originalFullScriptPath, String formattedScriptPath, String defaultName, boolean isLib, String caller) {
        boolean callByTranspiler;
        this.checkClosed();
        boolean bl = callByTranspiler = TranspilerEvalContext.get() != null;
        if (!callByTranspiler) {
            this.kingScriptContext.getLock().lock();
        }
        this.enter();
        this.context.resetLimits();
        String eventScriptPath = formattedScriptPath;
        Cost cost = null;
        try {
            Value value;
            cost = Collector.cost(EngineCostType.engine_eval.name(), formattedScriptPath).logOnClose().warnOnClose();
            boolean interactive = this.options.isInteractive();
            boolean cached = isLib && !this.debug && !DebugConfig.isDebuggable(formattedScriptPath);
            Source source = this.buildSource(js, originalFullScriptPath, interactive, false, cached, defaultName);
            logger.info(this.name + " " + caller + ": " + source.getName());
            if (eventScriptPath == null) {
                eventScriptPath = source.getName();
            }
            this.fireOnEvalBegin(eventScriptPath);
            if (this.enableTimeout && originalFullScriptPath != null) {
                this.levelControlTimeoutInterrupter.startTiming(source.getName(), originalFullScriptPath);
            }
            try (EvalContext evalContext = EvalContext.setup(this, originalFullScriptPath);){
                value = this.scriptEngine.eval2(source, this.scriptEngine.getContext());
            }
            if (interactive) {
                this.scriptEngine.getContext().getWriter().flush();
            }
            this.allBindings.setExport(ScriptValueImpl.create(value));
            this.fireOnEvalEnd(eventScriptPath);
            Object t = Types.js2java(value);
            return t;
        }
        catch (Throwable e) {
            block29: {
                if (cost != null) {
                    cost.setExceptionContext(e.getMessage());
                }
                this.fireOnEvalException(eventScriptPath, e);
                if (this.enableTimeout && originalFullScriptPath != null) {
                    try {
                        this.levelControlTimeoutInterrupter.onTimeout();
                    }
                    catch (ScriptException scriptException) {
                        if (cost == null) break block29;
                        cost.setExceptionContext(scriptException.getMessage());
                    }
                }
            }
            throw ScriptException.wrap(e);
        }
        finally {
            if (cost != null) {
                cost.close();
            }
            if (this.enableTimeout && originalFullScriptPath != null) {
                this.levelControlTimeoutInterrupter.endTiming();
            }
            this.leave();
            if (!callByTranspiler) {
                this.kingScriptContext.getLock().unlock();
            }
        }
    }

    @Override
    public Map<String, List<String>> listModuleTypes(String ... modules) {
        this.checkClosed();
        if (modules == null || modules.length == 0) {
            modules = ModuleExports.getSharedExportModules().toArray(new String[0]);
        }
        modules = ModuleExports.getSortedModules(modules);
        return this.libFileSystem.getScriptStore().listModuleTypes(modules);
    }

    @Override
    public ModuleExports listModuleExports(String ... modules) {
        this.checkClosed();
        if (modules == null || modules.length == 0) {
            modules = ModuleExports.getSharedExportModules().toArray(new String[0]);
        }
        return ModuleExportsManager.listModuleExports(this, modules);
    }

    public final Thread getOwnThread() {
        return this.ownThread.get();
    }

    public final void setOwnThread(Thread thread) {
        this.ownThread.set(thread);
    }

    public KingScriptEngine getTopWrapper() {
        return this.topWrapper == null ? this : this.topWrapper;
    }

    public void setTopWrapper(KingScriptEngine topWrapper) {
        this.topWrapper = topWrapper;
    }

    public void waitForClosed() {
        if (!this.listeners.isEmpty()) {
            this.waitLeaved();
            this.fireListener("fireWaitForClosed", cl -> cl.awaitForClose(this.getTopWrapper()));
        }
        this.waitLeaved();
    }

    public void fireOnClosed() {
        if (!this.listeners.isEmpty()) {
            this.fireListener("fireOnClosed", cl -> cl.onClosed(this.getTopWrapper()));
        }
    }

    private void fireOnEvalBegin(String scriptPath) {
        if (!this.listeners.isEmpty()) {
            this.fireListener("fireOnEvalBegin", cl -> cl.onEvalBegin(this.getTopWrapper(), scriptPath));
        }
    }

    private void fireOnEvalEnd(String scriptPath) {
        if (!this.listeners.isEmpty()) {
            this.fireListener("fireOnEvalEnd", cl -> cl.onEvalEnd(this.getTopWrapper(), scriptPath));
        }
    }

    private void fireOnEvalException(String scriptPath, Throwable e) {
        if (!this.listeners.isEmpty()) {
            this.fireListener("fireOnEvalException", cl -> cl.onEvalException(this.getTopWrapper(), scriptPath, e));
        }
    }

    private void fireListener(String name, EngineListenerTrigger trigger) {
        for (EngineListener cl : new ArrayList<EngineListener>(this.listeners)) {
            try {
                trigger.fire(cl);
            }
            catch (Exception e) {
                logger.error("Engine " + name + " error: " + cl, (Throwable)e);
            }
        }
    }

    public LevelTimeoutInterrupter getLevelControlTimeoutInterrupter() {
        return this.levelControlTimeoutInterrupter;
    }

    public boolean isEnableTimeout() {
        return this.enableTimeout;
    }

    private static interface EngineListenerTrigger {
        public void fire(EngineListener var1);
    }
}

