/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.lib.JarLibModuleLoader;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.util.Tuple;

public final class ModuleExports {
    private static final Map<String, ModuleExports> meMap = new ConcurrentHashMap<String, ModuleExports>();
    private static final List<String> orderedExportModules = new ArrayList<String>();
    private static final Set<String> constVersionModules = new HashSet<String>(6);
    private static final Map<String, Boolean> constVersionModuleScriptPathMap = new ConcurrentHashMap<String, Boolean>(1024);
    private static final String json_key_path = "paths";
    private static final String json_key_export = "exports";
    private final ModuleExports shared;
    private final String id;
    private Map<String, Integer> pathMap = new TreeMap<String, Integer>();
    private Map<Integer, String> antiPathMap = new TreeMap<Integer, String>();
    private Map<String, Set<Integer>> exportMap = new TreeMap<String, Set<Integer>>();
    private Map<String, String> errorMap = new TreeMap<String, String>();
    private Map<String, String> moduleVersionMap = new HashMap<String, String>();
    private Set<String> usedModuleSet = new HashSet<String>();
    private String jsonString;

    static void addConstVersionModules(String module, List<String> scriptPaths) {
        int prefixLen = module.length();
        for (String scriptPath : scriptPaths) {
            int dot = scriptPath.indexOf(46);
            if (dot != -1) {
                scriptPath = scriptPath.substring(0, dot);
            }
            String[] segs = scriptPath.substring(prefixLen + 1).split("/");
            StringBuilder path = new StringBuilder(scriptPath.length());
            path.append(module);
            for (String seg : segs) {
                path.append('/').append(seg);
                constVersionModuleScriptPathMap.put(path.toString(), Boolean.TRUE);
            }
        }
    }

    public static boolean isConstVersionModule(String scriptPath) {
        if (scriptPath != null) {
            Boolean b = constVersionModuleScriptPathMap.get(scriptPath);
            if (b != null) {
                return b;
            }
            for (String module : constVersionModules) {
                if (!scriptPath.equals(module) && !scriptPath.startsWith(module + "/")) continue;
                constVersionModuleScriptPathMap.put(scriptPath, Boolean.TRUE);
                return true;
            }
            constVersionModuleScriptPathMap.put(scriptPath, Boolean.FALSE);
        }
        return false;
    }

    static Set<String> getSharedExportModules() {
        return constVersionModules;
    }

    public static Set<String> readSharedExportModules() {
        return Collections.unmodifiableSet(constVersionModules);
    }

    public static String[] getSortedModules(String[] modules) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String module : modules) {
            int order = orderedExportModules.indexOf(module);
            if (order == -1) {
                map.put("a" + module, module);
                continue;
            }
            map.put("b" + order, module);
        }
        return map.values().toArray(new String[modules.length]);
    }

    public static Tuple<String[], String[]> getCommonAndBizModules(String[] modules) {
        ArrayList<String> commonModules = new ArrayList<String>();
        ArrayList<String> bizModules = new ArrayList<String>();
        for (String module : modules) {
            int order = orderedExportModules.indexOf(module);
            if (order == -1) {
                commonModules.add(module);
                continue;
            }
            bizModules.add(module);
        }
        return new Tuple<String[], String[]>(commonModules.toArray(new String[0]), bizModules.toArray(new String[0]));
    }

    public static ModuleExports getOrCreate() {
        return ModuleExports.getOrCreate(AccountProvider.get().getAccountId());
    }

    static ModuleExports getOrCreate(String id) {
        if (id.equals("ACCOUNT_SHARED")) {
            return meMap.computeIfAbsent(id, k -> new ModuleExports((String)k, null));
        }
        ModuleExports shared = meMap.get("ACCOUNT_SHARED");
        return meMap.computeIfAbsent(id, k -> new ModuleExports((String)k, shared));
    }

    private ModuleExports(String id, ModuleExports shared) {
        this.id = id;
        this.shared = shared;
    }

    public ModuleExports getShared() {
        return this.shared;
    }

    public boolean isShared() {
        return this.id.equals("ACCOUNT_SHARED");
    }

    void mergeUsed(ModuleExports other) {
        this.pathMap.putAll(other.pathMap);
        this.antiPathMap.putAll(other.antiPathMap);
        for (Map.Entry<String, Set<Integer>> item : other.exportMap.entrySet()) {
            this.exportMap.put(item.getKey(), new TreeSet(item.getValue()));
        }
        this.errorMap.putAll(other.errorMap);
        this.moduleVersionMap.putAll(other.moduleVersionMap);
        for (String module : this.getResolvedModules()) {
            if (this.usedModuleSet.contains(module)) continue;
            this.removeModule(module);
        }
    }

    public Set<String> getResolvedModules() {
        return new HashSet<String>(this.moduleVersionMap.keySet());
    }

    public String getModuleVersion(String module) {
        return this.moduleVersionMap.get(module);
    }

    public void setModuleVersion(String module, String version) {
        this.moduleVersionMap.put(module, version);
    }

    void addUsedModule(String module) {
        this.usedModuleSet.add(module);
    }

    Set<String> getUsedModuleSet() {
        return this.usedModuleSet;
    }

    public void removeModule(String module) {
        if (this.moduleVersionMap.remove(module) != null) {
            this.usedModuleSet.remove(module);
            String pathPrefix = module + "/";
            ArrayList<Integer> pathCodeList = new ArrayList<Integer>();
            for (String path : new ArrayList<String>(this.pathMap.keySet())) {
                if (!path.equals(module) && !path.startsWith(pathPrefix)) continue;
                Integer code = this.pathMap.remove(path);
                pathCodeList.add(code);
                this.antiPathMap.remove(code);
            }
            for (String path : new ArrayList<String>(this.errorMap.keySet())) {
                if (!path.equals(module) && !path.startsWith(pathPrefix)) continue;
                this.errorMap.remove(path);
            }
            if (!pathCodeList.isEmpty()) {
                HashMap<String, Set<Integer>> map = new HashMap<String, Set<Integer>>(this.exportMap);
                for (Map.Entry item : map.entrySet()) {
                    Set set = (Set)item.getValue();
                    set.removeAll(pathCodeList);
                    if (!set.isEmpty()) continue;
                    this.exportMap.remove(item.getKey());
                }
            }
        }
    }

    public void addExport(String path, String export) {
        this.exportMap.computeIfAbsent(export, k -> new TreeSet()).add(this.getPathCode(this.formatPath(path)));
    }

    public void addError(String path, String error) {
        this.errorMap.put(path, error);
    }

    public List<String> getPaths() {
        return new ArrayList<String>(this.pathMap.keySet());
    }

    public List<String> getModulePaths(String module) {
        ArrayList<String> ret = new ArrayList<String>();
        String prefix = module + '/';
        for (String path : this.pathMap.keySet()) {
            if (!path.equals(module) && !path.startsWith(module)) continue;
            ret.add(path);
        }
        return ret;
    }

    public List<String> getExportPaths(String export) {
        ArrayList<String> ret = new ArrayList<String>();
        Set<Integer> set = this.exportMap.get(export);
        if (set != null) {
            for (Integer key : set) {
                ret.add(this.antiPathMap.get(key));
            }
        }
        return ret;
    }

    public List<String> getExports(String path) {
        Integer code = this.pathMap.get(path = this.formatPath(path));
        if (code == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, Set<Integer>> item : this.exportMap.entrySet()) {
            if (!item.getValue().contains(code)) continue;
            ret.add(item.getKey());
        }
        return ret;
    }

    private String formatPath(String path) {
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith("/index")) {
            path = path.substring(0, path.length() - 6);
        }
        return path;
    }

    private Integer getPathCode(String path) {
        Integer value = this.pathMap.get(path);
        if (value == null) {
            value = this.pathMap.size() + 1;
            this.pathMap.put(path, value);
            this.antiPathMap.put(value, path);
        }
        return value;
    }

    public String toJSONString() {
        return this.jsonString;
    }

    void genJSONString() {
        if (this.shared == null) {
            this.jsonString = this.toJSONString0();
        } else {
            ModuleExports me = new ModuleExports(this.id, null);
            me.usedModuleSet.addAll(this.usedModuleSet);
            me.mergeUsed(this);
            me.mergeUsed(this.shared);
            this.jsonString = me.toJSONString0();
        }
    }

    private String toJSONString0() {
        HashMap<String, Map<Integer, String>> json = new HashMap<String, Map<Integer, String>>();
        json.put(json_key_path, this.antiPathMap);
        TreeMap exportMap2 = new TreeMap();
        for (Map.Entry<String, Set<Integer>> item : this.exportMap.entrySet()) {
            List list = item.getValue().stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
            exportMap2.put(item.getKey(), list);
        }
        json.put(json_key_export, exportMap2);
        return JSON.toJSONString(json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNonStringKeyAsString});
    }

    public String toString() {
        return "{id='" + this.id + '\'' + ", moduleVersion=" + this.moduleVersionMap + ", paths=" + this.pathMap.size() + ", exports=" + this.exportMap.size() + ", shared=" + (this.shared == null ? "" : this.shared.toString()) + '}';
    }

    static {
        orderedExportModules.add("@cosmic/bos-framework");
        orderedExportModules.add("@cosmic/bos-util");
        orderedExportModules.add("@cosmic/bos-core");
        orderedExportModules.add("@cosmic/bos-script");
        orderedExportModules.add("@cosmic/bos-internal-jdk");
        constVersionModules.addAll(JarLibModuleLoader.getModules().stream().map(LibModule::getName).collect(Collectors.toList()));
        for (String module : constVersionModules) {
            constVersionModuleScriptPathMap.put(module, Boolean.TRUE);
        }
    }
}

