/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine.bindings;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import kd.sdk.kingscript.engine.bindings.ScriptBinding;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.Types;

public final class ScriptBindingImpl
implements ScriptBinding {
    final Set<String> constKeySet = new HashSet<String>();
    final Set<String> globalKeySet = new HashSet<String>();
    private final Bindings bindings;

    public ScriptBindingImpl(Bindings bindings) {
        this.bindings = bindings;
    }

    @Override
    public <T> T get(String key) {
        return Types.js2java(this.bindings.get(key));
    }

    @Override
    public void put(String key, Object value) {
        this.doPut(key, value, ScopeTypeEnum.NORMAL);
    }

    @Override
    public void putConst(String key, Object value) {
        this.doPut(key, value, ScopeTypeEnum.CONST);
    }

    @Override
    public void putGlobal(String key, Object value) {
        this.doPut(key, value, ScopeTypeEnum.GLOBAL);
    }

    private void doPut(String key, Object value, ScopeTypeEnum type) {
        if (this.constKeySet.contains(key)) {
            throw new ScriptException("const property cannot be reassigned: " + key);
        }
        if (this.globalKeySet.contains(key)) {
            throw new ScriptException("global property cannot be reassigned: " + key);
        }
        switch (type) {
            case NORMAL: {
                this.bindings.put(key, value);
                break;
            }
            case CONST: {
                this.bindings.put(key, value);
                this.constKeySet.add(key);
                break;
            }
            case GLOBAL: {
                this.bindings.put(key, value);
                this.globalKeySet.add(key);
            }
        }
    }

    @Override
    public Object remove(String key) {
        return this.bindings.remove(key);
    }

    @Override
    public void clear() {
        this.bindings.clear();
    }

    @Override
    public boolean has(String key) {
        return this.bindings.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.bindings.keySet();
    }

    @Override
    public Set<String> constKeySet() {
        return Collections.unmodifiableSet(this.constKeySet);
    }

    @Override
    public Set<String> globalKeySet() {
        return Collections.unmodifiableSet(this.globalKeySet);
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    private static enum ScopeTypeEnum {
        NORMAL,
        CONST,
        GLOBAL;

    }
}

