/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine.compile;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.engine.compile.CompileResult;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.util.Tuple;

public final class CompileTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CompileResult> compile(KingScriptEngine scriptEngine, Map<String, String> tsSourceMap) {
        HashMap<String, CompileResult> ret = new HashMap<String, CompileResult>();
        KingScriptEngineImpl engine = scriptEngine.unwrap(KingScriptEngineImpl.class);
        LibFileSystem lfs = engine.getLibFileSystem();
        LibModule compileLibModule = LibModule.ofMemory("", tsSourceMap);
        lfs.attachCompile(compileLibModule);
        try {
            for (Map.Entry<String, String> entry : tsSourceMap.entrySet()) {
                String scriptPath = entry.getKey();
                String source = entry.getValue();
                CompileResult cr = new CompileResult();
                cr.setSource(source);
                cr.setScriptPath(scriptPath);
                Tuple<ByteSeekableByteChannel, Object> tp = engine.evalPath(scriptPath, false);
                Object value = tp.getValue();
                if (value instanceof Map) {
                    Map exportMap = (Map)value;
                    cr.getExports().putAll(exportMap);
                }
                ByteSeekableByteChannel bc = tp.getKey();
                cr.setTarget(bc.getCompiledScript());
                cr.setSourceMapping(bc.getSourceMap().getMappings());
                ret.put(scriptPath, cr);
            }
        }
        finally {
            lfs.detachCompile();
        }
        return ret;
    }
}

