/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine.inherit;

import com.oracle.truffle.js.runtime.util.LRUCache;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.sdk.kingscript.config.AccountProvider;

public class AdapterClassCache {
    private static final AtomicInteger suffixSeq = new AtomicInteger();
    private static final LRUCache<String, Object> cache = new LRUCache(4096);
    private static final Map<String, Object> lockMap = new ConcurrentHashMap<String, Object>(1024);

    public static int getAdapterClassNameSuffixSeq() {
        return suffixSeq.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getOrGeneratedClassLoader(Class<?> superClass, List<Class<?>> interfaces, ClassLoader commonLoader, boolean classOverride, Supplier<T> generator) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(superClass.getName());
        if (!"ACCOUNT_SHARED".equals(AccountProvider.get().getAccountId())) {
            sb.append("#").append(AccountProvider.get().getAccountId());
        }
        if (!interfaces.isEmpty()) {
            for (Class<?> cls : interfaces) {
                sb.append('#').append(cls.getName());
            }
        }
        sb.append('#').append(commonLoader).append('#').append(classOverride ? (char)'0' : '1');
        String key = sb.toString();
        Object ret = cache.get((Object)key);
        if (ret == null) {
            Object lock = lockMap.get(key);
            if (lock == null) {
                lock = lockMap.computeIfAbsent(key, k -> new Object());
            }
            Object object = lock;
            synchronized (object) {
                ret = cache.get((Object)key);
                if (ret == null) {
                    ret = generator.get();
                    cache.put((Object)key, ret);
                }
            }
        }
        return (T)ret;
    }
}

