/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.engine.inherit;

import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.host.adapters.HostAdapterServices;
import kd.sdk.kingscript.exception.ScriptException;
import org.graalvm.polyglot.Value;

public class ScriptExtendJava {
    public static final String CONSTRUCTOR = "constructor";
    private static final String SUPER_PREFIX = "super$";
    private static final int SUPER_PREFIX_LENGTH = "super$".length();
    private static final ThreadLocal<Call> hookOnDefineInheritClass = new ThreadLocal();
    public static final String CALL_SCRIPT_CONSTRUCTOR = "callScriptConstructor";

    public static CallClosable hookOnConstructor(Call callable) {
        hookOnDefineInheritClass.set(callable);
        return hookOnDefineInheritClass::remove;
    }

    public static void callJavaConstructor(Object ... args) {
        Call callable = hookOnDefineInheritClass.get();
        if (callable != null) {
            callable.call(args);
        }
    }

    public static void callScriptConstructor(Value overrides, Object superObject, Object ... args) {
        Value superObjectValue = Value.asValue((Object)superObject);
        for (String sp : superObjectValue.getMemberKeys()) {
            String p;
            if (!sp.startsWith(SUPER_PREFIX) || overrides.hasMember(p = sp.substring(SUPER_PREFIX_LENGTH))) continue;
            overrides.putMember(p, (Object)superObjectValue.getMember(sp));
        }
        overrides.putMember("super", (Object)superObjectValue.getMember("super"));
        overrides.getMember(CONSTRUCTOR).executeVoid(args);
    }

    public static Object invokeMember(Object javaAdapter, String name, Object[] args) throws UnknownIdentifierException {
        Value classOverrides;
        try {
            classOverrides = HostAdapterServices.getClassOverrides(javaAdapter.getClass().getClassLoader());
            if (!classOverrides.hasMember(name)) {
                throw UnknownIdentifierException.create((String)name);
            }
        }
        catch (UnknownIdentifierException e) {
            throw e;
        }
        catch (Throwable e) {
            throw UnknownIdentifierException.create((String)name);
        }
        return classOverrides.getMember(name).execute(args);
    }

    public static Object readMember(Object javaAdapter, String name) throws UnknownIdentifierException {
        Value classOverrides;
        if (javaAdapter instanceof Exception) {
            throw ScriptException.wrap((Exception)javaAdapter);
        }
        try {
            classOverrides = HostAdapterServices.getClassOverrides(javaAdapter.getClass().getClassLoader());
            if (!classOverrides.hasMember(name)) {
                throw UnknownIdentifierException.create((String)name);
            }
        }
        catch (UnknownIdentifierException e) {
            throw e;
        }
        catch (Throwable e) {
            throw UnknownIdentifierException.create((String)name);
        }
        return classOverrides.getMember(name);
    }

    public static void writeMember(Object javaAdapter, String name, Object value) throws UnknownIdentifierException {
        Value classOverrides;
        try {
            classOverrides = HostAdapterServices.getClassOverrides(javaAdapter.getClass().getClassLoader());
            if (!classOverrides.hasMember(name)) {
                throw UnknownIdentifierException.create((String)name);
            }
        }
        catch (UnknownIdentifierException e) {
            throw e;
        }
        catch (Throwable e) {
            throw UnknownIdentifierException.create((String)name);
        }
        classOverrides.putMember(name, value);
    }

    public static interface CallClosable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface Call {
        public void call(Object ... var1);
    }
}

