/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.global;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.global.GlobalNamesConf;

public class GlobalObject {
    private static final Set<String> globalMembers;

    public static Set<String> getGlobalMembers() {
        return globalMembers;
    }

    public static void setupInterop(JSRealm realm, ScriptOptions options) {
        DynamicObject globalObject = realm.getGlobalObject();
        GlobalObject.putGlobalConstProperty("NULL", Undefined.instance, realm);
        DynamicObject kingscriptObject = (DynamicObject)globalObject.get((Object)"Java");
        GlobalObject.putGlobalConstProperty("$", kingscriptObject, realm);
        GlobalObject.putConstProperty(kingscriptObject, "packages", JSObject.get((DynamicObject)globalObject, (Object)"Packages"), realm);
        for (Property property : globalObject.getShape().getPropertyList()) {
            Object key = property.getKey();
            if (key instanceof Symbol || GlobalNamesConf.allow(String.valueOf(key))) continue;
            JSObject.delete((DynamicObject)globalObject, (Object)key);
        }
    }

    public static void putGlobalProperty(Object key, Object value, JSRealm realm) {
        GlobalObject.putProperty(realm.getGlobalObject(), key, value, realm);
    }

    public static void putGlobalConstProperty(Object key, Object value, JSRealm realm) {
        GlobalObject.putConstProperty(realm.getGlobalObject(), key, value, realm);
    }

    public static void putProperty(DynamicObject jsObject, Object key, Object value, JSRealm realm) {
        JSObjectUtil.putDataProperty((JSContext)realm.getContext(), (DynamicObject)jsObject, (Object)key, (Object)value, (int)JSAttributes.getDefaultNotEnumerable());
    }

    public static void putConstProperty(DynamicObject jsObject, Object key, Object value, JSRealm realm) {
        JSObjectUtil.putDataProperty((JSContext)realm.getContext(), (DynamicObject)jsObject, (Object)key, (Object)value, (int)JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    public static void setSealed(DynamicObject jsObject, boolean sealed) {
        assert (JSRuntime.isObject(jsObject));
        JSObject.setIntegrityLevel((DynamicObject)jsObject, (boolean)sealed);
    }

    public static void putConstPropertyEnumerable(Object key, Object value) {
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        JSObjectUtil.putDataProperty((JSContext)realm.getContext(), (DynamicObject)realm.getGlobalObject(), (Object)key, (Object)value, (int)JSAttributes.notConfigurableEnumerableNotWritable());
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("Long");
        set.add("Date");
        set.add("BigDecimal");
        set.add("Super");
        set.add("newArray");
        globalMembers = Collections.unmodifiableSet(set);
    }
}

