/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.host;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class InterfacesCache {
    private static final Map<Class<?>, Class<?>[]> interfacesMap = new ConcurrentHashMap();

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        if (clazz.getTypeName().endsWith("$$Adapter")) {
            HashSet interfaces = new HashSet();
            for (Class<?> newCls = clazz; newCls != null; newCls = newCls.getSuperclass()) {
                interfaces.addAll(Arrays.asList(newCls.getInterfaces()));
            }
            return interfaces.toArray(new Class[interfaces.size()]);
        }
        Class<?>[] classes = interfacesMap.get(clazz);
        if (classes != null) {
            return classes;
        }
        return interfacesMap.computeIfAbsent(clazz, k -> {
            HashSet interfaces = new HashSet();
            while (k != null) {
                interfaces.addAll(Arrays.asList(k.getInterfaces()));
                k = k.getSuperclass();
            }
            return interfaces.toArray(new Class[interfaces.size()]);
        });
    }
}

