/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.host;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.bos.thread.ThreadTruck;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.host.ScriptProxy;
import kd.sdk.kingscript.types.ScriptValue;

public class PluginScriptProxy
extends ScriptProxy {
    public static final String SCRIPT_PLUGIN_EXPORT_NAME = "plugin";
    private static final String TH_INVOKE_COUNT = "thInvokeCount";
    private static List<String> blackClassNames = new ArrayList<String>(3);

    public PluginScriptProxy(String scriptPath, Function<String, KingScriptEngine> autoDebugEngineCreator) {
        super(scriptPath, autoDebugEngineCreator);
    }

    @Override
    protected ScriptValue getHostObject() {
        try {
            return this.engine.getBindings().getExport().getMember(SCRIPT_PLUGIN_EXPORT_NAME);
        }
        catch (Throwable e) {
            String msg = e.getMessage() + ", " + this.scriptPath;
            try {
                Set<String> memberKeys = this.engine.getBindings().getExport().getMemberKeys();
                msg = msg + " export memberKeys: " + memberKeys;
            }
            catch (Throwable e2) {
                msg = msg + " export ScriptValue: " + this.engine.getBindings().getExport();
            }
            logger.error(msg);
            throw new ScriptException(msg, e);
        }
    }

    @Override
    protected Object call(String name, Object[] args) throws Throwable {
        if (this.engine != null) {
            this.engine.enter();
        }
        try {
            switch (name) {
                case "hashCode": {
                    if (args != null && args.length != 0) break;
                    Integer n = this.hostObject.hashCode();
                    return n;
                }
                case "toString": {
                    if (args != null && args.length != 0) break;
                    String string = this.hostObject.toString();
                    return string;
                }
                case "getPluginName": {
                    if (args != null && args.length != 0) break;
                    String string = this.scriptPath == null ? this.getPluginName() : this.scriptPath;
                    return string;
                }
                case "destroy": 
                case "destory": 
                case "onReturnOperation": {
                    if (!this.isEngineClosed()) {
                        this.doCall(name, args);
                        this.destroy();
                    }
                    Object var5_11 = null;
                    return var5_11;
                }
                case "pageRelease": {
                    if (!this.isEngineClosed()) {
                        this.doCall(name, args);
                        this.onPageRelease();
                    }
                    Object var5_12 = null;
                    return var5_12;
                }
            }
            Object object = this.doCall(name, args);
            return object;
        }
        catch (Throwable e) {
            if ("registerListener".equals(name)) {
                Object var4_6 = null;
                return var4_6;
            }
            if (this.engine == null) {
                Object var4_7 = null;
                return var4_7;
            }
            logger.error(this.getClass().getSimpleName() + " call " + name + " error.", e);
            throw e;
        }
        finally {
            if (this.engine != null) {
                this.engine.leave();
            }
        }
    }

    private Object[] filterLoggableArguments(Object[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        ArrayList<Object> allowLoggerArgs = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            if (blackClassNames.contains(arg.getClass().getName())) continue;
            allowLoggerArgs.add(arg);
        }
        return allowLoggerArgs.toArray();
    }

    private void destroy() {
        Object cnt = ThreadTruck.get((Object)TH_INVOKE_COUNT);
        if (cnt instanceof Integer && (Integer)cnt > 0) {
            return;
        }
        this.callCloseEngine();
    }

    private void onPageRelease() {
        this.callCloseEngine();
    }

    private void callCloseEngine() {
        if (!this.isEngineClosed()) {
            new WeakReference<ScriptValue>(this.hostObject);
            this.hostObject = null;
            this.closeEngine();
        }
    }

    private String getPluginName() {
        return this.getHostObject().asJavaObject().getClass().getName();
    }

    static {
        blackClassNames.add("kd.bos.form.events.LoadCustomControlMetasArgs");
        blackClassNames.add("kd.bos.form.events.LoadWaterMarkInfoEventArgs");
        blackClassNames.add("kd.bos.form.events.PreOpenFormEventArgs");
    }
}

