/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ByteSeekableByteChannel;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.LibFileSystemContext;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.PathResolver;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.lib.ScriptPaths;
import kd.sdk.kingscript.lib.TypeScriptLibTranspiler;
import kd.sdk.kingscript.lib.crypto.CryptoUtil;
import kd.sdk.kingscript.lib.store.ScriptMixedStore;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Collector;
import kd.sdk.kingscript.monitor.cost.Cost;
import kd.sdk.kingscript.monitor.cost.EngineCostType;
import kd.sdk.kingscript.transpiler.TransResult;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;
import org.apache.commons.lang3.StringUtils;
import org.graalvm.polyglot.io.FileSystem;
import org.slf4j.Logger;

public abstract class AbstractLibFileSystem
implements FileSystem {
    protected static final Logger logger = Logs.getLogger();
    protected final LibFileSystemContext context = new LibFileSystemContext();
    protected final ScriptStore scriptStore;
    private final TypeScriptLibTranspiler transpiler;
    private boolean debug;
    protected LibModule compileLibModule;

    public AbstractLibFileSystem(TypeScriptLibTranspiler transpiler, ScriptStore scriptStore, boolean debug) {
        this.transpiler = transpiler;
        this.debug = debug;
        this.scriptStore = scriptStore;
    }

    public void attachCompile(LibModule compileLibModule) {
        this.getLibModules().put("", compileLibModule);
        ((ScriptMixedStore)this.scriptStore).setLibFileSystem((LibFileSystem)this);
        this.compileLibModule = compileLibModule;
    }

    public void detachCompile() {
        this.getLibModules().remove("");
        ((ScriptMixedStore)this.scriptStore).setLibFileSystem((LibFileSystem)this);
        this.compileLibModule = null;
    }

    public boolean isCompileAttached() {
        return this.compileLibModule != null;
    }

    private boolean isCompilingScript(String scriptPath) {
        return this.compileLibModule != null && this.compileLibModule.tryLookupPaths(scriptPath) != null;
    }

    public LibFileSystemContext getLibFileSystemContext() {
        return this.context;
    }

    public ScriptStore getScriptStore() {
        return this.scriptStore;
    }

    private Path makeRootPath(String path) {
        return Paths.get(path, new String[0]);
    }

    protected abstract String tryLookupPaths(String var1, String ... var2);

    protected abstract String tryLookupPath(String var1, String var2);

    protected abstract Map<String, LibModule> getLibModules();

    protected abstract Set<String> getLibModuleNameSetWithAlias();

    public Path parsePath(URI uri) {
        return this.makeRootPath(uri.toString());
    }

    public Path parsePath(String path) {
        return this.makeRootPath(path);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteSeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newByteChannel(path.toString());
    }

    public ByteSeekableByteChannel newByteChannel(String path) throws IOException {
        path = this.formatAccountPath(path);
        ByteSeekableByteChannel bc = this.doNewByteChannel(path);
        KingScriptContext ctx = KingScriptContext.get();
        if (ctx != null) {
            ctx.setLastLoaded(bc);
        }
        return bc;
    }

    private String formatAccountPath(String path) {
        String accountPrefix = AccountProvider.get().getAccountId() + "#";
        if (path.startsWith(accountPrefix)) {
            path = path.substring(accountPrefix.length());
        }
        return path;
    }

    private String getLibFileSystemCacheKey(boolean debuggable, String formattedFilePath) {
        return (debuggable ? "1#" : "0#") + formattedFilePath;
    }

    public boolean hasUpdated(String scriptPath) {
        String accountId;
        if (this.isCompilingScript(scriptPath)) {
            return true;
        }
        String cacheVersion = ScriptVersionManager.getVersion(scriptPath, this.getLibModules().values());
        Collection<LibModule> libModules = this.getLibModules().values();
        String formattedFilePath = ScriptPathFormat.format(scriptPath, libModules);
        boolean debuggable = this.debug && DebugConfig.isDebuggable(formattedFilePath);
        String cacheKey = this.getLibFileSystemCacheKey(debuggable, formattedFilePath);
        Map<String, ByteSeekableByteChannel> libFileSystemCache = GlobalCache.get().getLibFileSystemCache();
        ByteSeekableByteChannel bc = libFileSystemCache.get(cacheKey);
        if (!(cacheVersion != null && bc != null || "ACCOUNT_SHARED".equals(accountId = AccountProvider.get().getAccountId()))) {
            String accountCacheKey = accountId + "#" + cacheKey;
            String versionKey = accountId + "#" + scriptPath;
            cacheVersion = ScriptVersionManager.getVersion(versionKey, this.getLibModules().values());
            bc = libFileSystemCache.get(accountCacheKey);
        }
        return cacheVersion == null || bc == null || !cacheVersion.equals(bc.getVersion());
    }

    private ByteSeekableByteChannel getCachedBC(Map<String, ByteSeekableByteChannel> cache, Collection<LibModule> libModules, String path, boolean debuggable) {
        String accountCacheKey;
        String accountId;
        String cacheKey = this.getLibFileSystemCacheKey(debuggable, path);
        String debuggableCacheKey = this.getLibFileSystemCacheKey(!debuggable, path);
        ByteSeekableByteChannel bc = cache.get(cacheKey);
        if (bc != null) {
            String version = ScriptVersionManager.getVersion(path, libModules);
            if (Objects.equals(bc.getVersion(), version)) {
                return bc.copy();
            }
            cache.remove(cacheKey);
            cache.remove(debuggableCacheKey);
        }
        if (!"ACCOUNT_SHARED".equals(accountId = AccountProvider.get().getAccountId()) && (bc = cache.get(accountCacheKey = accountId + "#" + cacheKey)) != null) {
            String versionKey = accountId + "#" + path;
            String version = ScriptVersionManager.getVersion(versionKey, libModules);
            if (Objects.equals(bc.getVersion(), version)) {
                return bc.copy();
            }
            cache.remove(accountCacheKey);
            String accountDebuggableCacheKey = accountId + "#" + debuggableCacheKey;
            cache.remove(accountDebuggableCacheKey);
            return null;
        }
        return bc;
    }

    private ByteSeekableByteChannel doNewByteChannel(String path) {
        try (Cost cost = Collector.cost(EngineCostType.engine_load_script.name(), path);){
            TransResult transResult;
            ByteSeekableByteChannel bc;
            boolean debuggable;
            Map<String, ByteSeekableByteChannel> cache = GlobalCache.get().getLibFileSystemCache();
            String filePath = path.replace('\\', '/');
            boolean isGlobalPath = filePath.startsWith("/@") || filePath.startsWith("@") || this.context.getLibModule() != null && this.context.getLibModule().isDevMode();
            Collection<LibModule> libModules = this.getLibModules().values();
            String formattedFilePath = ScriptPathFormat.format(filePath, libModules);
            boolean bl = debuggable = this.debug && DebugConfig.isDebuggable(formattedFilePath);
            if (isGlobalPath && !this.isCompilingScript(formattedFilePath) && (bc = this.getCachedBC(cache, libModules, formattedFilePath, debuggable)) != null) {
                ByteSeekableByteChannel byteSeekableByteChannel = bc;
                return byteSeekableByteChannel;
            }
            String lookupPath = null;
            PathResolver pr = PathResolver.resolve(filePath, this.getLibModuleNameSetWithAlias());
            if (filePath.startsWith("/@") || pr.moduleName.startsWith("@")) {
                String basePath = pr.scriptPath;
                String[] tryPaths = ScriptPaths.tryPaths(basePath, debuggable);
                lookupPath = this.tryLookupPaths(pr.moduleName, tryPaths);
            }
            if (lookupPath == null && (lookupPath = ScriptPaths.tryLookupPath(filePath, pr, this, debuggable)) == null) {
                File modelDir = new File("script_modules");
                String msg = "Lib file does not exists: path=" + path + ", scriptStore=" + this.scriptStore + ", modules=" + libModules + ", " + "script_modules" + "=" + (modelDir.exists() && modelDir.isDirectory() ? Arrays.asList(modelDir.list()) : "not_exists");
                logger.error(msg);
                throw new ScriptException(msg);
            }
            LibModule currentLibModule = this.context.getLibModule();
            if (!isGlobalPath && currentLibModule.isDevMode()) {
                isGlobalPath = true;
            }
            String scriptPath = currentLibModule.getScriptPath(lookupPath);
            String formattedScriptPath = ScriptPathFormat.format(scriptPath, libModules);
            this.context.setLastLoadFullPath(scriptPath);
            this.context.setLastLoadFullPath(formattedScriptPath);
            String cacheKey = this.getLibFileSystemCacheKey(debuggable, formattedScriptPath);
            if (!this.isCompilingScript(formattedFilePath) && (bc = this.getCachedBC(cache, libModules, formattedScriptPath, debuggable)) != null) {
                ByteSeekableByteChannel byteSeekableByteChannel = bc;
                return byteSeekableByteChannel;
            }
            ScriptInfo scriptInfo = this.scriptStore.load(lookupPath);
            if (scriptInfo == null) {
                String msg = "Lib file does not exists: lookupPath=" + lookupPath;
                throw new ScriptException(msg);
            }
            String accountId = scriptInfo.getAccountId();
            String originalScript = scriptInfo.getScript();
            String compiledScriptContent = scriptInfo.getCompileScript();
            String version = scriptInfo.getVersion();
            String scriptType = scriptInfo.getScriptType();
            boolean isCompilingScript = this.isCompilingScript(formattedFilePath);
            String compiledScript = null;
            SourceMap sourceMap = null;
            String lw = lookupPath.toLowerCase();
            if (lw.endsWith(".d.ts") || lw.endsWith(".js")) {
                compiledScript = originalScript;
            } else if (CryptoUtil.isCryptoScript(lw)) {
                compiledScript = CryptoUtil.decrypt(originalScript);
            } else if (StringUtils.isNotBlank((CharSequence)compiledScriptContent)) {
                compiledScript = CryptoUtil.decrypt(compiledScriptContent);
                String srcMap = scriptInfo.getSourceMap();
                if (StringUtils.isNotBlank((CharSequence)srcMap)) {
                    sourceMap = SourceMap.decode(srcMap, false);
                }
            } else if (StringUtils.isNotBlank((CharSequence)originalScript) && StringUtils.isBlank((CharSequence)compiledScript)) {
                transResult = this.transpiler.trans(originalScript, scriptPath, scriptInfo);
                compiledScript = transResult.getCode();
                sourceMap = transResult.getSourceMap();
            } else if (isCompilingScript) {
                transResult = this.transpiler.trans(originalScript, scriptPath, scriptInfo);
                compiledScript = transResult.getCode();
                sourceMap = transResult.getSourceMap();
            }
            if (StringUtils.isNotBlank((CharSequence)scriptType) && compiledScript == null) {
                throw new ScriptException(lookupPath + " is not compiled.Please save again.");
            }
            if (compiledScript == null) {
                compiledScript = "";
            }
            String newFormattedScriptPath = formattedScriptPath;
            String newLookupPath = lookupPath;
            String newCacheKey = cacheKey;
            String newFormattedFilePath = formattedFilePath;
            if (!"ACCOUNT_SHARED".equals(accountId)) {
                newFormattedScriptPath = accountId + "#" + formattedScriptPath;
                newLookupPath = accountId + "#" + lookupPath;
                newCacheKey = accountId + "#" + cacheKey;
                newFormattedFilePath = accountId + "#" + formattedFilePath;
            }
            bc = new ByteSeekableByteChannel(scriptPath, newFormattedScriptPath, newLookupPath, originalScript, compiledScript, sourceMap, version, scriptInfo, accountId);
            if (!isCompilingScript) {
                cache.put(newCacheKey, bc);
                if (isGlobalPath) {
                    if (newFormattedFilePath.equals(newFormattedScriptPath)) {
                        String filePathCacheKey = this.getLibFileSystemCacheKey(debuggable, formattedFilePath);
                        if (!"ACCOUNT_SHARED".equals(accountId)) {
                            filePathCacheKey = accountId + "#" + filePathCacheKey;
                        }
                        cache.put(filePathCacheKey, bc);
                    }
                    if (!newFormattedFilePath.equals(newFormattedScriptPath)) {
                        ScriptVersionManager.setSamePath(newFormattedFilePath, newFormattedScriptPath, libModules);
                    }
                }
                ScriptVersionManager.setVersion(newFormattedFilePath, version, libModules);
            }
            ByteSeekableByteChannel byteSeekableByteChannel = bc;
            return byteSeekableByteChannel;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Path toAbsolutePath(Path path) {
        return Paths.get("/", new String[0]).resolve(path).normalize();
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        return this.toAbsolutePath(path);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return Collections.singletonMap("isRegularFile", Boolean.TRUE);
    }

    public String getSeparator() {
        return "/";
    }

    public String getMimeType(Path path) {
        return "application/javascript+module";
    }
}

