/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;

public class ByteSeekableByteChannel
implements SeekableByteChannel {
    public static final ByteSeekableByteChannel EMPTY = new ByteSeekableByteChannel("", "", "", "", "", null, "", null, ""){

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String getCompiledScript() {
            return null;
        }
    };
    private int size;
    private ReadableByteChannel channel;
    private String scriptPath;
    private String formattedScriptPath;
    private String lookupPath;
    private String originalScript;
    private String compiledScript;
    private SourceMap sourceMap;
    private String version;
    private ScriptInfo scriptInfo;
    private String accountId;

    public ByteSeekableByteChannel(String scriptPath, String formattedScriptPath, String lookupPath, String originalScript, String compiledScript, SourceMap sourceMap, String version, ScriptInfo scriptInfo) {
        this(scriptPath, formattedScriptPath, lookupPath, originalScript, compiledScript, sourceMap, version, scriptInfo, "");
    }

    public ByteSeekableByteChannel(String scriptPath, String formattedScriptPath, String lookupPath, String originalScript, String compiledScript, SourceMap sourceMap, String version, ScriptInfo scriptInfo, String accountId) {
        this.scriptPath = scriptPath;
        this.formattedScriptPath = formattedScriptPath;
        this.lookupPath = lookupPath;
        this.originalScript = originalScript;
        this.compiledScript = compiledScript;
        this.sourceMap = sourceMap;
        this.version = version;
        this.scriptInfo = scriptInfo;
        this.accountId = accountId;
        try {
            byte[] bytes = compiledScript.getBytes("UTF-8");
            this.size = bytes.length;
            this.channel = Channels.newChannel(new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new ScriptException(e);
        }
    }

    private ByteSeekableByteChannel() {
    }

    public ByteSeekableByteChannel copy() {
        ByteSeekableByteChannel bc = new ByteSeekableByteChannel();
        bc.size = this.size;
        bc.channel = this.channel;
        bc.scriptPath = this.scriptPath;
        bc.formattedScriptPath = this.formattedScriptPath;
        bc.lookupPath = this.lookupPath;
        bc.originalScript = this.originalScript;
        bc.compiledScript = this.compiledScript;
        bc.sourceMap = this.sourceMap;
        bc.version = this.version;
        bc.scriptInfo = this.scriptInfo;
        bc.accountId = this.accountId;
        try {
            byte[] bytes = this.compiledScript.getBytes("UTF-8");
            bc.channel = Channels.newChannel(new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new ScriptException(e);
        }
        return bc;
    }

    public String getCompiledScript() {
        return this.compiledScript;
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    public String getOriginalScript() {
        return this.originalScript;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getFormattedScriptPath() {
        return this.formattedScriptPath;
    }

    public String getLookupPath() {
        return this.lookupPath;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel truncate(long sizeParam) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return this.version;
    }

    public ScriptInfo getScriptInfo() {
        return this.scriptInfo;
    }

    public String getAccountId() {
        return this.accountId;
    }
}

