/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.sdk.kingscript.lib.AbstractLibFileSystem;
import kd.sdk.kingscript.lib.AbstractLibModule;
import kd.sdk.kingscript.lib.JarLibModuleLoader;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.LibModuleOfMemory;
import kd.sdk.kingscript.lib.LibModuleOfStore;
import kd.sdk.kingscript.lib.TypeScriptLibTranspiler;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.util.Tuple;
import org.slf4j.Logger;

public class LibFileSystem
extends AbstractLibFileSystem {
    private static final Logger logger = Logs.getLogger();
    private final List<LibModule> orderedModuleList = new ArrayList<LibModule>(32);
    private Map<String, LibModule> nameMap = new HashMap<String, LibModule>(8);
    private Map<String, List<LibModule>> aliasMap = new HashMap<String, List<LibModule>>(2);
    private Set<String> moduleNameSetWithAlias = new HashSet<String>(12);

    public LibFileSystem(TypeScriptLibTranspiler transpiler, LibModule[] modules, ScriptStore scriptStore, boolean debug) {
        super(transpiler, scriptStore, debug);
        ArrayList<LibModule> devModuleList = new ArrayList<LibModule>(2);
        ArrayList<LibModule> nonDevModuleList = new ArrayList<LibModule>(8);
        ArrayList<LibModule> inputModules = new ArrayList<LibModule>(modules.length + 32);
        inputModules.addAll(Arrays.asList(modules));
        inputModules.addAll(JarLibModuleLoader.loadJarModules());
        HashSet<String> parsedModuleNameSet = new HashSet<String>();
        for (LibModule module : inputModules) {
            if (module instanceof LibModuleOfStore) {
                ((LibModuleOfStore)module).setScriptStore(scriptStore);
                for (LibModule libModule : ((LibModuleOfStore)module).parseModuleWithDependencies(((LibModuleOfStore)module).getStoreRootPath(), parsedModuleNameSet)) {
                    ((LibModuleOfStore)libModule).setScriptStore(scriptStore);
                    if (libModule.isDevMode()) {
                        devModuleList.add(libModule);
                        continue;
                    }
                    nonDevModuleList.add(libModule);
                }
                continue;
            }
            if (module.isDevMode()) {
                devModuleList.add(module);
                continue;
            }
            nonDevModuleList.add(module);
        }
        HashSet<String> nameSet = new HashSet<String>(devModuleList.size() + nonDevModuleList.size());
        for (LibModule module : devModuleList) {
            if (!nameSet.add(module.getName())) continue;
            this.orderedModuleList.add(module);
        }
        for (LibModule module : nonDevModuleList) {
            if (!nameSet.add(module.getName())) continue;
            this.orderedModuleList.add(module);
        }
        for (LibModule module : this.orderedModuleList) {
            String string;
            ((AbstractLibModule)module).debug = debug;
            this.nameMap.put(module.getName(), module);
            this.moduleNameSetWithAlias.add(module.getName());
            if (!(module instanceof LibModuleOfStore) || (string = ((LibModuleOfStore)module).getAlias()) == null || string.length() <= 0) continue;
            List list = this.aliasMap.computeIfAbsent(string, k -> new ArrayList(2));
            list.add(module);
            this.moduleNameSetWithAlias.add(string);
        }
    }

    public LibModule getLibModule(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public Map<String, LibModule> getLibModules() {
        return this.nameMap;
    }

    @Override
    protected Set<String> getLibModuleNameSetWithAlias() {
        return this.moduleNameSetWithAlias;
    }

    @Override
    protected String tryLookupPaths(String moduleName, String ... scriptPaths) {
        Tuple<Integer, String> ret;
        LibModule module;
        if (this.isCompileAttached()) {
            LibModule compileLibModule = this.nameMap.get("");
            String[] fullScriptPaths = new String[scriptPaths.length];
            int i = 0;
            for (String scriptPath : scriptPaths) {
                fullScriptPaths[i++] = moduleName + '/' + scriptPath;
            }
            Tuple<Integer, String> tp = compileLibModule.tryLookupPaths(fullScriptPaths);
            if (tp != null) {
                this.context.setLastLoad(compileLibModule, tp.getValue());
                return tp.getValue();
            }
        }
        if ((module = this.nameMap.get(moduleName)) != null && (ret = module.tryLookupPaths(scriptPaths)) != null) {
            this.context.setLastLoad(module, scriptPaths[ret.getKey()]);
            return ret.getValue();
        }
        List<LibModule> libModules = this.aliasMap.get(moduleName);
        if (libModules != null) {
            for (LibModule libModule : libModules) {
                Tuple<Integer, String> ret2 = libModule.tryLookupPaths(scriptPaths);
                if (ret2 == null) continue;
                this.context.setLastLoad(libModule, scriptPaths[ret2.getKey()]);
                return ret2.getValue();
            }
        }
        return this.lookupDynamicModule(moduleName, scriptPaths);
    }

    private String lookupDynamicModule(String moduleName, String ... scriptPaths) {
        String[] fullScriptPaths = null;
        for (LibModule libModule : this.nameMap.values()) {
            Tuple<Integer, String> tp;
            if (!(libModule instanceof LibModuleOfMemory)) continue;
            if (fullScriptPaths == null) {
                fullScriptPaths = new String[scriptPaths.length];
                int i = 0;
                for (String scriptPath : scriptPaths) {
                    fullScriptPaths[i++] = moduleName + '/' + scriptPath;
                }
            }
            if ((tp = libModule.tryLookupPaths(fullScriptPaths)) == null) continue;
            this.context.setLastLoad(libModule, tp.getValue());
            return tp.getValue();
        }
        if (moduleName != null && !this.scriptStore.isFileStore()) {
            String[] pp = new String[scriptPaths.length];
            for (int i = 0; i < scriptPaths.length; ++i) {
                pp[i] = (moduleName + '/' + scriptPaths[i]).replace('\\', '/').replace("//", "/");
            }
            int p = this.scriptStore.exists(pp);
            if (p != -1) {
                String scriptPath = scriptPaths[p];
                LibModuleOfStore dynamicLoadedModule = new LibModuleOfStore(moduleName, this.scriptStore);
                dynamicLoadedModule.setName(moduleName);
                this.nameMap.put(moduleName, dynamicLoadedModule);
                this.orderedModuleList.add(dynamicLoadedModule);
                this.context.setLastLoad(dynamicLoadedModule, scriptPath);
                LibFileSystem.logLookupPath(dynamicLoadedModule, scriptPath);
                return pp[p];
            }
        }
        return null;
    }

    @Override
    protected String tryLookupPath(String moduleName, String scriptPath) {
        LibModule lastModule;
        String ret;
        LibModule module = this.nameMap.get(moduleName);
        if (module != null) {
            String ret2 = module.tryLookupPath(scriptPath);
            if (ret2 != null) {
                this.context.setLastLoad(module, scriptPath);
                LibFileSystem.logLookupPath(module, scriptPath);
            }
            return ret2;
        }
        List<LibModule> libModules = this.aliasMap.get(moduleName);
        if (libModules != null) {
            for (LibModule libModule : libModules) {
                ret = libModule.tryLookupPath(scriptPath);
                if (ret == null) continue;
                this.context.setLastLoad(libModule, scriptPath);
                LibFileSystem.logLookupPath(libModule, scriptPath);
                return ret;
            }
        }
        if ((lastModule = this.context.getLibModule()) != null) {
            String realPath = (moduleName.isEmpty() ? "" : moduleName + '/') + scriptPath;
            String lastPath = this.context.getPath();
            int i = lastPath.lastIndexOf(47);
            if (i != -1) {
                realPath = lastPath.substring(0, i + 1) + scriptPath;
            }
            if ((ret = lastModule.tryLookupPath(realPath)) != null) {
                LibFileSystem.logLookupPath(lastModule, realPath);
                return ret;
            }
        }
        if ((ret = this.lookupDynamicModule(moduleName, scriptPath)) != null) {
            return ret;
        }
        scriptPath = moduleName == null ? scriptPath : moduleName + '/' + scriptPath;
        for (LibModule libModule : this.orderedModuleList) {
            if (!libModule.isDevMode() || (ret = libModule.tryLookupPath(scriptPath)) == null) continue;
            this.context.setLastLoad(libModule, scriptPath);
            LibFileSystem.logLookupPath(libModule, scriptPath);
            return ret;
        }
        return null;
    }

    private static void logLookupPath(LibModule libModule, String scriptPath) {
        logger.info("#require [" + libModule.getName() + "] " + scriptPath);
    }

    public void enterLoadModule(Source source, JSModuleData moduleData) {
    }

    public void leaveLoadModule(Source source, JSModuleData moduleData) {
    }

    public void enterResolveImportedModule(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
    }

    public void leaveResolveImportedModule(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
    }
}

