/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.lib.AbstractLibModule;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.util.Tuple;

public class LibModuleOfMemory
extends AbstractLibModule {
    protected final Map<String, ScriptInfo> scriptMap = new ConcurrentHashMap<String, ScriptInfo>();
    protected final String name;

    public LibModuleOfMemory(String name, Map<String, String> scriptMap) {
        this.name = name;
        for (Map.Entry<String, String> item : scriptMap.entrySet()) {
            String fullPath = ScriptPathFormat.format(name + '/' + item.getKey());
            ScriptInfo si = new ScriptInfo(item.getValue());
            this.scriptMap.put(fullPath, si);
        }
    }

    public ScriptInfo load(String fullPath) {
        ScriptInfo si = this.scriptMap.get(fullPath);
        if (si == null) {
            si = this.scriptMap.get(ScriptPathFormat.format(fullPath));
        }
        return si;
    }

    @Override
    public List<String> listTypes() {
        return new ArrayList<String>(this.scriptMap.keySet());
    }

    @Override
    public String tryLookupPath(String path) {
        return this.name + '/' + path;
    }

    @Override
    public Tuple<Integer, String> tryLookupPaths(String ... paths) {
        int i = 0;
        for (String path : paths) {
            path = ScriptPathFormat.format(this.name + '/' + path);
            if (this.scriptMap.containsKey(path)) {
                return new Tuple<Integer, String>(i, path);
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getScriptPath(String lookupPath) {
        return lookupPath;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getVersion() {
        return "1.0.0";
    }

    @Override
    public void setScriptRootPath(String scriptRootPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDevMode() {
        return true;
    }

    @Override
    public void setDevMode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.name + this.scriptMap.keySet();
    }
}

