/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import kd.sdk.kingscript.lib.LibModuleOfMemory;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.ScriptPaths;
import kd.sdk.kingscript.util.Tuple;

public class LibModuleOfResource
extends LibModuleOfMemory {
    private final String resourceRootPath;

    public LibModuleOfResource(String name) {
        this(name, (String)null);
    }

    public LibModuleOfResource(String name, String resourceRootPath) {
        super(name, Collections.emptyMap());
        if (resourceRootPath == null) {
            resourceRootPath = "";
        } else if (!resourceRootPath.isEmpty()) {
            if (!resourceRootPath.startsWith("/")) {
                resourceRootPath = '/' + resourceRootPath;
            }
            while (resourceRootPath.endsWith("/")) {
                resourceRootPath = resourceRootPath.substring(0, resourceRootPath.length() - 1);
            }
        }
        this.resourceRootPath = resourceRootPath;
    }

    @Override
    public ScriptInfo load(String fullPath) {
        String[] tryPaths;
        Tuple<Integer, String> tp;
        ScriptInfo si = (ScriptInfo)this.scriptMap.get(fullPath);
        if (si != null) {
            return si;
        }
        if (fullPath.startsWith(this.name + '/') && (tp = this.tryLookupPaths(tryPaths = ScriptPaths.tryPaths(fullPath.substring(this.name.length() + 1), this.debug))) != null) {
            return this.doLoad(this.name + '/' + tryPaths[tp.getKey()]);
        }
        return null;
    }

    private ScriptInfo doLoad(String fullPath) {
        ScriptInfo si = (ScriptInfo)this.scriptMap.get(fullPath);
        if (si == null && fullPath.startsWith(this.name + '/')) {
            String relPath = this.resourceRootPath + fullPath.substring(this.name.length());
            try (InputStream is = this.getClass().getResourceAsStream(relPath);){
                if (is != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
                    byte[] buf = new byte[4096];
                    int len = 0;
                    while ((len = is.read(buf)) != -1) {
                        bos.write(buf, 0, len);
                    }
                    String script = bos.toString("UTF-8");
                    si = new ScriptInfo(script);
                    this.scriptMap.put(fullPath, si);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return si;
    }

    @Override
    public Tuple<Integer, String> tryLookupPaths(String ... paths) {
        int i = 0;
        for (String path : paths) {
            path = this.name + '/' + path;
            if (!this.scriptMap.containsKey(path)) {
                if (this.doLoad(path) != null) {
                    return new Tuple<Integer, String>(i, path);
                }
                ++i;
                continue;
            }
            return new Tuple<Integer, String>(i, path);
        }
        return null;
    }
}

