/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.InvalidPathException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.AbstractLibModule;
import kd.sdk.kingscript.lib.LibModuleAlias;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.util.Tuple;

public class LibModuleOfStore
extends AbstractLibModule {
    private static final String package_build_time = "buildTime";
    private static final String package_version = "version";
    private static final String package_name = "name";
    private static final String package_dependencies = "dependencies";
    private static final String modulePackage = "package.json";
    private static final AtomicInteger nonePackageJsonSeq = new AtomicInteger();
    private String name;
    private String alias;
    private String moduleVersion = "1.0.0";
    private final String storeRootPath;
    private String scriptRootPath = "";
    private String fullPath = "";
    protected boolean devMode = false;
    ScriptStore scriptStore;

    @Override
    public List<String> listTypes() {
        ArrayList<String> list = new ArrayList<String>(128);
        this.collectTypes(new File(this.fullPath), this.name, list);
        Collections.sort(list);
        return list;
    }

    private void collectTypes(File root, String pathPrefix, List<String> cc) {
        if (root.isFile()) {
            String fileName = root.getName();
            String versionParameter = "&v=" + this.getVersion();
            if (fileName.toLowerCase().endsWith(".ts")) {
                cc.add(pathPrefix + '/' + fileName + versionParameter);
            }
        } else {
            for (File file : root.listFiles()) {
                this.collectTypes(file, file.isDirectory() ? pathPrefix + '/' + file.getName() : pathPrefix, cc);
            }
        }
    }

    @Override
    public String tryLookupPath(String path) {
        String ret;
        boolean onlyPath = false;
        if (!path.startsWith(this.fullPath) || !new File(path).exists()) {
            try {
                ret = this.fullPath + path;
            }
            catch (InvalidPathException e) {
                ret = path;
                onlyPath = true;
            }
        } else {
            ret = path;
            onlyPath = true;
        }
        if (this.scriptStore.exists(ret.replace('\\', '/').replace("//", "/"))) {
            return ret;
        }
        if (!onlyPath && !this.scriptStore.isFileStore() && this.scriptStore.exists((ret = path).replace('\\', '/').replace("//", "/"))) {
            return ret;
        }
        return null;
    }

    @Override
    public Tuple<Integer, String> tryLookupPaths(String ... paths) {
        String[] pp = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            pp[i] = (this.fullPath + paths[i]).replace('\\', '/').replace("//", "/");
        }
        int p = this.scriptStore.exists(pp);
        if (p != -1) {
            return new Tuple<Integer, String>(p, pp[p]);
        }
        if (!this.scriptStore.isFileStore() && !this.fullPath.isEmpty()) {
            for (int i = 0; i < paths.length; ++i) {
                pp[i] = paths[i].replace('\\', '/').replace("//", "/");
            }
            p = this.scriptStore.exists(pp);
            if (p != -1) {
                return new Tuple<Integer, String>(p, pp[p]);
            }
        }
        return null;
    }

    @Override
    public String getScriptPath(String lookupPath) {
        String scriptPath = this.fullPath != null && !this.fullPath.isEmpty() && lookupPath.startsWith(this.fullPath) ? lookupPath.substring(this.fullPath.length()) : lookupPath;
        if (this.name == null || this.name.isEmpty()) {
            if (!scriptPath.isEmpty() && scriptPath.charAt(0) == '/') {
                scriptPath = scriptPath.substring(1);
            }
            return scriptPath;
        }
        if (scriptPath.startsWith(this.name + '/')) {
            return scriptPath;
        }
        return this.name + '/' + scriptPath;
    }

    List<LibModuleOfStore> parseModuleWithDependencies(String rootPath, Set<String> parsedModuleNameSet) {
        if (this.scriptStore.isFileStore()) {
            try {
                return this.parseByLocalFile(rootPath, parsedModuleNameSet, true);
            }
            catch (ScriptException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    return Collections.singletonList(this);
                }
                throw e;
            }
        }
        try {
            return this.parseByLocalFile(rootPath, parsedModuleNameSet, true);
        }
        catch (Exception e) {
            return this.parseByDB(parsedModuleNameSet, true);
        }
    }

    private List<LibModuleOfStore> parseByDB(Set<String> parsedModuleNameSet, boolean forceParse) {
        ArrayList<LibModuleOfStore> ret = new ArrayList<LibModuleOfStore>();
        List<String> dependencies = this.parsePackageJson();
        if (parsedModuleNameSet.add(this.name) || forceParse) {
            ret.add(this);
            for (String dependency : dependencies) {
                LibModuleOfStore module = new LibModuleOfStore(dependency, this.scriptStore);
                ret.addAll(module.parseByDB(parsedModuleNameSet, false));
            }
        }
        return ret;
    }

    private List<LibModuleOfStore> parseByLocalFile(String rootPath, Set<String> parsedModuleNameSet, boolean forceParse) {
        ArrayList<LibModuleOfStore> ret = new ArrayList<LibModuleOfStore>();
        List<String> dependencies = this.parsePackageJson();
        if (parsedModuleNameSet.add(this.name) || forceParse) {
            ret.add(this);
            String dependencyPathPrefix = rootPath + "/node_modules/";
            if (new File(dependencyPathPrefix).exists()) {
                for (String dependency : dependencies) {
                    LibModuleOfStore module = new LibModuleOfStore(dependencyPathPrefix + dependency, this.scriptStore);
                    ret.addAll(module.parseByLocalFile(rootPath, parsedModuleNameSet, false));
                }
            }
        }
        return ret;
    }

    private List<String> parsePackageJson() {
        String packageJson;
        ScriptInfo scriptInfo;
        String rootPath = this.storeRootPath.isEmpty() ? "" : this.storeRootPath + '/';
        this.fullPath = (rootPath + this.scriptRootPath).replace('\\', '/').replace("//", "/");
        if (!this.fullPath.endsWith("/")) {
            this.fullPath = this.fullPath + '/';
        }
        if ((scriptInfo = this.scriptStore.load(packageJson = (rootPath + modulePackage).replace("\\", "/").replace("//", "/"))) != null) {
            JSONObject json = JSON.parseObject((String)scriptInfo.getScript());
            this.setName(json.getString(package_name));
            this.setModuleVersion(json.getString(package_version), json.getString(package_build_time));
            JSONObject dependencies = json.getJSONObject(package_dependencies);
            if (dependencies != null) {
                return new ArrayList<String>(dependencies.keySet());
            }
        } else {
            this.setNonePackageJsonModuleName();
        }
        return Collections.emptyList();
    }

    public LibModuleOfStore(String rootPath) {
        this(rootPath, null);
    }

    LibModuleOfStore(String rootPath, ScriptStore scriptStore) {
        this.storeRootPath = rootPath;
        this.scriptStore = scriptStore;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setNonePackageJsonModuleName() {
        this.name = "none_package_json_module" + nonePackageJsonSeq.getAndIncrement();
    }

    void setScriptStore(ScriptStore scriptStore) {
        this.scriptStore = scriptStore;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setAlias(LibModuleAlias.getAlias(name));
    }

    void setModuleVersion(String version, String buildTime) {
        Date date = null;
        if (buildTime != null) {
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(buildTime);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.moduleVersion = date == null ? version : version + "@" + date.getTime();
    }

    public String getAlias() {
        return this.alias;
    }

    void setAlias(String alias) {
        this.alias = alias;
    }

    public String getStoreRootPath() {
        return this.storeRootPath;
    }

    public String getScriptRootPath() {
        return this.scriptRootPath;
    }

    @Override
    public void setScriptRootPath(String scriptRootPath) {
        this.scriptRootPath = scriptRootPath;
    }

    @Override
    public boolean isDevMode() {
        return this.devMode || this.scriptRootPath != null && !this.scriptRootPath.isEmpty();
    }

    @Override
    public void setDevMode() {
        this.devMode = true;
    }

    @Override
    public String getVersion() {
        return this.moduleVersion;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", version='" + this.moduleVersion + '\'' + ", path='" + this.storeRootPath + '\'' + ", fullPath='" + this.fullPath + '\'' + ", scriptPath='" + this.scriptRootPath + '\'' + '}';
    }
}

