/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib;

import kd.sdk.kingscript.lib.AbstractLibFileSystem;
import kd.sdk.kingscript.lib.PathResolver;

public final class ScriptPaths {
    public static final String COMPILED_SUFFIX = ".c";
    public static final String COMPILED_MIN_SUFFIX = ".c.min";

    static String[] tryPaths(String basePath, boolean debuggable) {
        if (!basePath.endsWith(".ts") && !basePath.endsWith(".js")) {
            String compiledSuffix = debuggable ? COMPILED_SUFFIX : COMPILED_MIN_SUFFIX;
            return new String[]{basePath + ".ts" + compiledSuffix, basePath + "/index.ts" + compiledSuffix, basePath + ".ts", basePath + "/index.ts", basePath + ".js", basePath + "/index.js"};
        }
        return new String[]{basePath};
    }

    static String tryLookupPath(String filePath, PathResolver pr, AbstractLibFileSystem libFileSystem, boolean debuggable) {
        String lookupPath = libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath);
        if (lookupPath == null && !filePath.endsWith(".ts") && !filePath.endsWith(".js")) {
            String compiledSuffix = debuggable ? COMPILED_SUFFIX : COMPILED_MIN_SUFFIX;
            lookupPath = pr.scriptPath.isEmpty() ? libFileSystem.tryLookupPath("", pr.moduleName + ".ts" + compiledSuffix) : libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath + ".ts" + compiledSuffix);
            if (lookupPath == null) {
                lookupPath = libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath + "/index.ts" + compiledSuffix);
            }
            if (lookupPath == null) {
                lookupPath = pr.scriptPath.isEmpty() ? libFileSystem.tryLookupPath("", pr.moduleName + ".ts") : libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath + ".ts");
                if (lookupPath == null) {
                    lookupPath = libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath + "/index.ts");
                }
                if (lookupPath == null && (lookupPath = pr.scriptPath.isEmpty() ? libFileSystem.tryLookupPath("", pr.moduleName + ".js") : libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath + ".js")) == null) {
                    lookupPath = libFileSystem.tryLookupPath(pr.moduleName, pr.scriptPath + "/index.js");
                }
            }
        }
        return lookupPath;
    }
}

