/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.crypto;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.sdk.kingscript.exception.ScriptException;

public final class AES {
    public static final int KEY_LEN = 32;
    public static final int IV_LEN = 12;
    private static final int GCM_TAG_LENGTH = 96;
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final String CHARSET_NAME = "UTF-8";
    private final SecretKeySpec secretKey;
    private final GCMParameterSpec ivSpec;
    private final byte[] key;
    private final byte[] iv;
    private final String id;

    private static byte[] genRandomBytes(SecureRandom secureRandom, int size) {
        byte[] bs = new byte[size];
        secureRandom.nextBytes(bs);
        return bs;
    }

    static String genID(byte[] key, byte[] iv) {
        byte[] bs = new byte[key.length + iv.length];
        System.arraycopy(key, 0, bs, 0, key.length);
        System.arraycopy(iv, 0, bs, key.length, iv.length);
        return new String(bs);
    }

    AES() {
        this(new SecureRandom());
    }

    private AES(SecureRandom secureRandom) {
        this(AES.genRandomBytes(secureRandom, 32), AES.genRandomBytes(secureRandom, 12));
    }

    public AES(byte[] key, byte[] iv) {
        this.id = AES.genID(key, iv);
        this.key = key;
        this.iv = iv;
        this.secretKey = new SecretKeySpec(key, "AES");
        this.ivSpec = new GCMParameterSpec(96, iv);
    }

    public byte[] encrypt(byte[] bs) {
        try {
            return this.createEncryptCipher().doFinal(bs);
        }
        catch (Exception e) {
            throw ScriptException.asRuntime(e);
        }
    }

    public byte[] decrypt(byte[] bs) {
        try {
            return this.createDecryptCipher().doFinal(bs);
        }
        catch (Exception e) {
            throw ScriptException.asRuntime(e);
        }
    }

    String encrypt(String script) {
        try {
            byte[] bs = this.createEncryptCipher().doFinal(script.getBytes(CHARSET_NAME));
            return new String(Base64.getEncoder().encode(bs), CHARSET_NAME);
        }
        catch (Exception e) {
            throw ScriptException.asRuntime(e);
        }
    }

    String decrypt(String encryptedScript) {
        try {
            byte[] bs = this.createDecryptCipher().doFinal(Base64.getDecoder().decode(encryptedScript.getBytes(CHARSET_NAME)));
            return new String(bs, CHARSET_NAME);
        }
        catch (Exception e) {
            throw ScriptException.asRuntime(e);
        }
    }

    private Cipher createEncryptCipher() throws Exception {
        Cipher encryptCipher = Cipher.getInstance(ALGORITHM);
        encryptCipher.init(1, (Key)this.secretKey, this.ivSpec);
        return encryptCipher;
    }

    private Cipher createDecryptCipher() throws Exception {
        Cipher decryptCipher = Cipher.getInstance(ALGORITHM);
        decryptCipher.init(2, (Key)this.secretKey, this.ivSpec);
        return decryptCipher;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getIV() {
        return this.iv;
    }

    String getId() {
        return this.id;
    }
}

