/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.crypto;

import com.oracle.truffle.js.runtime.util.LRUCache;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.lib.crypto.AES;

public final class AESPool {
    private static final Map<String, List<AES>> aesMap = new LRUCache(32);
    private static final int maxRetained = Math.max(Runtime.getRuntime().availableProcessors(), 4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AES getAny() {
        Map<String, List<AES>> map = aesMap;
        synchronized (map) {
            for (List<AES> list : aesMap.values()) {
                if (list.isEmpty()) continue;
                return list.remove(0);
            }
        }
        return new AES();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AES get(byte[] key, byte[] iv) {
        Map<String, List<AES>> map = aesMap;
        synchronized (map) {
            List<AES> list = aesMap.get(AES.genID(key, iv));
            if (list == null || list.isEmpty()) {
                return new AES(key, iv);
            }
            return list.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(AES aes) {
        Map<String, List<AES>> map = aesMap;
        synchronized (map) {
            List list = aesMap.computeIfAbsent(aes.getId(), k -> new LinkedList());
            if (list.size() < maxRetained) {
                list.add(aes);
            }
        }
    }
}

