/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.crypto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.crypto.CryptoService;
import kd.sdk.kingscript.lib.crypto.CryptoServiceFactorySpi;
import kd.sdk.kingscript.lib.crypto.DefaultCryptoService;
import kd.sdk.kingscript.log.Loggable;

public final class CryptoUtil {
    private static final Map<String, CryptoService> serviceMap = new ConcurrentHashMap<String, CryptoService>(4);
    private static final String nameAppendedPrefix = "[";
    private static final String nameAppendSuffix = "]";

    private static void checkName(String name, CryptoServiceFactorySpi spi) {
        if (name.contains(nameAppendedPrefix) || name.contains(nameAppendSuffix)) {
            throw new ScriptException("Incorrect CryptoService name \"" + name + "\"(contains:" + nameAppendedPrefix + nameAppendSuffix + ") in " + spi.getClass().getName());
        }
    }

    static void checkName(String name) {
        if (name.contains(nameAppendedPrefix) || name.contains(nameAppendSuffix)) {
            throw new ScriptException("Incorrect CryptoService name \"" + name + "\"(contains:" + nameAppendedPrefix + nameAppendSuffix + ").");
        }
    }

    public static boolean isCryptoScript(String scriptPath) {
        return scriptPath.endsWith(".ts.c") || scriptPath.endsWith(".ts.c.min");
    }

    public static String encrypt(String cryptoName, String script) {
        if (cryptoName == null || cryptoName.isEmpty() || script.isEmpty()) {
            return script;
        }
        CryptoService cryptoService = serviceMap.get(cryptoName);
        if (cryptoService == null) {
            throw new ScriptException("Not found the CryptoService: " + cryptoName);
        }
        return nameAppendedPrefix + cryptoName + nameAppendSuffix + cryptoService.encrypt(script);
    }

    public static String decrypt(String encryptedScript) {
        if (!encryptedScript.startsWith(nameAppendedPrefix)) {
            return encryptedScript;
        }
        int p = encryptedScript.indexOf(nameAppendSuffix);
        if (p == -1) {
            throw new ScriptException("Incorrect script: " + encryptedScript);
        }
        String cryptoName = encryptedScript.substring(nameAppendedPrefix.length(), p);
        if ((encryptedScript = encryptedScript.substring(p + nameAppendSuffix.length())).isEmpty()) {
            return encryptedScript;
        }
        CryptoService cryptoService = serviceMap.get(cryptoName);
        if (cryptoService == null) {
            throw new ScriptException("Not found the CryptoService: " + cryptoName);
        }
        return cryptoService.decrypt(encryptedScript);
    }

    public static CryptoService getService(String name) {
        return serviceMap.get(name);
    }

    public static Set<String> getServiceNames() {
        return Collections.unmodifiableSet(serviceMap.keySet());
    }

    static {
        ServiceLoader<CryptoServiceFactorySpi> spiList = ServiceLoader.load(CryptoServiceFactorySpi.class);
        HashMap<String, CryptoServiceFactorySpi> factoryMap = new HashMap<String, CryptoServiceFactorySpi>(4);
        for (CryptoServiceFactorySpi spi : spiList) {
            for (CryptoService cryptoService : spi.createCryptoServices()) {
                String name = cryptoService.getName();
                CryptoServiceFactorySpi existedFactory = (CryptoServiceFactorySpi)factoryMap.get(name);
                if (existedFactory != null) {
                    String error = "Existed the same \"" + name + "\" CryptoService in " + existedFactory.getClass().getName() + " and " + spi.getClass().getName() + ".";
                    throw new ScriptException(error);
                }
                CryptoUtil.checkName(name);
                factoryMap.put(name, spi);
                serviceMap.put(name, cryptoService);
                Loggable.logger.info("Load " + name + " CryptoService in " + spi.getClass().getName());
            }
        }
        if (!serviceMap.containsKey(DefaultCryptoService.INSTANCE.getName())) {
            serviceMap.put(DefaultCryptoService.INSTANCE.getName(), DefaultCryptoService.INSTANCE);
        }
    }
}

