/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.util.FileUtil;

public final class ScriptFileStore
implements ScriptStore {
    private LibFileSystem libFileSystem;

    void setLibFileSystem(LibFileSystem libFileSystem) {
        this.libFileSystem = libFileSystem;
    }

    @Override
    public boolean isFileStore() {
        return true;
    }

    @Override
    public int exists(String ... paths) {
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            if (!file.exists() || !file.isFile()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ScriptInfo load(String path) {
        try {
            this.checkScriptPath(path);
            String script = FileUtil.readString(Paths.get(path, new String[0]));
            String version = null;
            KingScriptEngineImpl engine = KingScriptEngineImpl.getCurrentEngineImpl();
            if (engine != null) {
                LibModule libModule = engine.getLibFileSystem().getLibFileSystemContext().getLibModule();
                version = libModule.getVersion();
            }
            return version == null ? new ScriptInfo(script) : new ScriptInfo(script, version);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private void checkScriptPath(String path) {
        if (path == null) {
            return;
        }
        if (path.contains("@") && (path.endsWith(".ts") || path.endsWith(".js") || path.endsWith(".min") || path.endsWith(".json"))) {
            return;
        }
        throw new ScriptException("ScriptFileStore.load error, path: " + path);
    }

    @Override
    public Map<String, List<String>> listModuleTypes(String ... modules) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(modules.length);
        for (String module : modules) {
            LibModule libModule = this.libFileSystem.getLibModule(module);
            if (libModule == null) continue;
            result.put(module, libModule.listTypes());
        }
        return result;
    }
}

