/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.LibModuleOfMemory;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.store.ScriptFileStore;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.util.Tuple;
import org.slf4j.Logger;

public final class ScriptMixedStore
implements ScriptStore {
    private static final Logger logger = Logs.getLogger();
    private final ScriptStore store;
    private final boolean mixed;
    private ScriptFileStore fileStore;
    private String fileStoreSimpleName;
    private final String storeStoreSimpleName;
    private List<LibModuleOfMemory> moduleOfMemoryList = new ArrayList<LibModuleOfMemory>();

    public static ScriptMixedStore wrap(ScriptStore store) {
        return new ScriptMixedStore(store);
    }

    private ScriptMixedStore(ScriptStore store) {
        this.store = store;
        this.storeStoreSimpleName = store.getClass().getSimpleName();
        boolean bl = this.mixed = !store.isFileStore();
        if (this.mixed) {
            this.fileStore = new ScriptFileStore();
            this.fileStoreSimpleName = this.fileStore.getClass().getSimpleName();
        }
    }

    public void setLibFileSystem(LibFileSystem libFileSystem) {
        if (this.mixed) {
            this.fileStore.setLibFileSystem(libFileSystem);
        }
        if (this.store instanceof ScriptFileStore) {
            ((ScriptFileStore)this.store).setLibFileSystem(libFileSystem);
        }
        this.moduleOfMemoryList.clear();
        for (LibModule libModule : libFileSystem.getLibModules().values()) {
            if (!(libModule instanceof LibModuleOfMemory)) continue;
            this.moduleOfMemoryList.add((LibModuleOfMemory)libModule);
        }
    }

    @Override
    public boolean isFileStore() {
        return this.store.isFileStore();
    }

    @Override
    public boolean exists(String path) {
        return this.mixed && this.fileStore.exists(path) || this.store.exists(path);
    }

    @Override
    public int exists(String ... paths) {
        return this.getExists(paths).getKey();
    }

    private Tuple<Integer, Boolean> getExists(String ... paths) {
        boolean constVersion;
        int p = -1;
        if (!this.moduleOfMemoryList.isEmpty()) {
            for (LibModuleOfMemory lib : this.moduleOfMemoryList) {
                Tuple<Integer, String> tp = lib.tryLookupPaths(paths);
                if (tp == null) continue;
                return new Tuple<Integer, Boolean>(tp.getKey(), true);
            }
        }
        if (this.mixed) {
            p = this.fileStore.exists(paths);
        }
        if (p == -1) {
            p = this.store.exists(paths);
            constVersion = false;
        } else {
            constVersion = true;
        }
        return new Tuple<Integer, Boolean>(p, constVersion);
    }

    @Override
    public ScriptInfo load(String path) {
        if (path.endsWith("package.json")) {
            Map<String, ScriptInfo> cache = GlobalCache.get().getStoreFileCache();
            ScriptInfo si = cache.get(path);
            if (si == null && (si = this.doLoad(path)) != null) {
                cache.put(path, si);
            }
            return si;
        }
        return this.doLoad(path);
    }

    private ScriptInfo doLoad(String path) {
        Supplier<ScriptInfo> sp = () -> {
            ScriptInfo si = null;
            if (!this.moduleOfMemoryList.isEmpty()) {
                for (LibModuleOfMemory lib : this.moduleOfMemoryList) {
                    si = lib.load(path);
                    if (si == null) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info("#load by LibModuleOfMemory " + path);
                    }
                    return si;
                }
            }
            if (this.mixed) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info("#load by " + this.fileStoreSimpleName + ' ' + path);
                    }
                    if ((si = this.fileStore.load(path)) != null) {
                        return si;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("#load by " + this.storeStoreSimpleName + ' ' + path);
            }
            si = this.store.load(path);
            return si;
        };
        return sp.get();
    }

    @Override
    public Map<String, List<String>> listModuleTypes(String ... modules) {
        TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>();
        if (this.mixed) {
            ret.putAll(this.fileStore.listModuleTypes(modules));
        }
        try {
            ret.putAll(this.store.listModuleTypes(modules));
        }
        catch (Exception e) {
            logger.warn("listModuleTypes: " + e.getMessage());
        }
        return ret;
    }

    public String toString() {
        return "{mixed=" + this.mixed + ", store=" + (this.store == null ? "" : this.store.getClass().getSimpleName()) + ", fileStore=" + (this.fileStore == null ? "" : this.fileStore.getClass().getSimpleName()) + '}';
    }
}

