/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.store.ScriptStore;

public final class ScriptResourceStore
implements ScriptStore {
    private final String resourceRootPath;

    public ScriptResourceStore() {
        this("/script/");
    }

    public ScriptResourceStore(String resourceRootPath) {
        resourceRootPath = resourceRootPath.replace('\\', '/');
        if (!resourceRootPath.startsWith("/")) {
            resourceRootPath = resourceRootPath + '/' + resourceRootPath;
        }
        if (!resourceRootPath.endsWith("/")) {
            resourceRootPath = resourceRootPath + '/';
        }
        this.resourceRootPath = resourceRootPath;
    }

    @Override
    public int exists(String ... paths) {
        int i = 0;
        for (String path : paths) {
            if (ScriptResourceStore.class.getResource(this.resourceRootPath + path) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ScriptInfo load(String path) {
        InputStream is = ScriptResourceStore.class.getResourceAsStream(this.resourceRootPath + path);
        if (is == null) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(is);){
            int len;
            StringBuilder script = new StringBuilder(1024);
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                script.append(buf, 0, len);
            }
            ScriptInfo scriptInfo = new ScriptInfo(script.toString());
            return scriptInfo;
        }
        catch (IOException e) {
            throw new ScriptException("Read script resource error: " + this.resourceRootPath + path, e);
        }
    }

    @Override
    public Map<String, List<String>> listModuleTypes(String ... modules) {
        return Collections.emptyMap();
    }
}

