/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Set;
import kd.sdk.kingscript.lib.tgz.DependenciesTSEntity;
import kd.sdk.kingscript.lib.tgz.ParseJavaJar;
import kd.sdk.kingscript.lib.tgz.ParseTsTgz;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenpendenciesParse {
    private static final Logger logger = LoggerFactory.getLogger(DenpendenciesParse.class);

    public static void parseLibRepoJar(Set<String> localModuleSet, String libJarPath, String outLibPath) {
        try {
            DependenciesTSEntity sdkEntity = libJarPath.endsWith(".jar") ? ParseJavaJar.getTgzForJar(libJarPath, outLibPath) : DenpendenciesParse.getModuleTgz(libJarPath, outLibPath);
            if (null == sdkEntity.getSdkOutPathList() || sdkEntity.getSdkOutPathList().size() <= 0) {
                return;
            }
            String localSdkTgzPath = sdkEntity.getSdkPath();
            if (StringUtils.isEmpty((CharSequence)localSdkTgzPath)) {
                logger.info("localSdkTgz is null : " + libJarPath);
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)sdkEntity.getSubModuleName()) && localModuleSet.contains(sdkEntity.getSubModuleName())) {
                new File(localSdkTgzPath).delete();
                logger.info("tgz\u5df2\u7ecf\u89e3\u538b\u8fc7\uff0c\u65e0\u9700\u91cd\u590d\u89e3\u538b : " + libJarPath);
                return;
            }
            localModuleSet.add(sdkEntity.getSubModuleName());
            logger.info("parse jar : " + libJarPath);
            logger.info("parse tgz : " + localSdkTgzPath);
            logger.info("parent module : " + sdkEntity.getParentModuleName());
            logger.info("sub module : " + sdkEntity.getSubModuleName());
            ParseTsTgz.extractTgzFile(outLibPath, localSdkTgzPath, sdkEntity);
        }
        catch (Exception ex) {
            logger.error("parse jar error, jar path = ", (Object)libJarPath);
            logger.error("parse jar error", (Throwable)ex);
        }
    }

    private static DependenciesTSEntity getModuleTgz(String libJarPath, String targetOut) {
        try {
            DependenciesTSEntity sdkDataWithJavaJarDto = new DependenciesTSEntity();
            ArrayList<String> sdkOutPathList = new ArrayList<String>();
            sdkDataWithJavaJarDto.setSdkOutPathList(sdkOutPathList);
            String tgzParentPath = libJarPath + File.separator + "script";
            File tgzParentDir = new File(tgzParentPath);
            if (!tgzParentDir.exists() || tgzParentDir.listFiles().length <= 0) {
                return sdkDataWithJavaJarDto;
            }
            for (File file : tgzParentDir.listFiles()) {
                if (file.isFile() && file.getName().endsWith(".tgz")) {
                    String outTgz = targetOut + File.separator + file.getName();
                    Files.copy(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(outTgz, new String[0]), new CopyOption[0]);
                    sdkOutPathList.add(outTgz);
                    continue;
                }
                if (!file.getName().equals("sdk_module_config")) continue;
                try (BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));){
                    ParseJavaJar.extractConfigWithJavaLib(reader, sdkDataWithJavaJarDto);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return sdkDataWithJavaJarDto;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

