/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.lib.tgz.DependenciesTSEntity;
import kd.sdk.kingscript.lib.tgz.KingScriptListrenerImpl;
import kd.sdk.kingscript.lib.tsparser.KingScriptLexer;
import kd.sdk.kingscript.lib.tsparser.KingScriptParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class IndexDTSMerger {
    private static Map<String, KingScriptListrenerImpl> listenerMap = new ConcurrentHashMap<String, KingScriptListrenerImpl>();
    private static Map<String, Set<String>> referenceMap = new ConcurrentHashMap<String, Set<String>>();
    private String indexDTSPath;

    public static void destoryListener() {
        if (null != referenceMap && referenceMap.size() > 0) {
            referenceMap.clear();
        }
        if (null != listenerMap && listenerMap.size() > 0) {
            listenerMap.clear();
        }
    }

    public IndexDTSMerger(File indexDTSFile, DependenciesTSEntity depenTSEntity) {
        String indexDTSKey = this.getIndexDTSKey(depenTSEntity.getParentModuleMark(), depenTSEntity.getParentModuleName());
        listenerMap.computeIfAbsent(indexDTSKey, k -> new KingScriptListrenerImpl());
        this.indexDTSPath = indexDTSFile.getAbsolutePath();
        Set referenceSet = referenceMap.computeIfAbsent(indexDTSFile.getAbsolutePath(), k -> new HashSet());
        if (null != depenTSEntity.getExportClassList() && depenTSEntity.getExportClassList().size() > 0) {
            referenceSet.addAll(depenTSEntity.getExportClassList());
        }
    }

    private String getIndexDTSKey(String parentModuleMark, String parentModuleName) {
        return parentModuleMark + "::" + parentModuleName;
    }

    public void merger(DependenciesTSEntity depenTSEntity, String filePath, Long buildTime, Set<String> moduleClassSet) {
        String indexDTSKey = this.getIndexDTSKey(depenTSEntity.getParentModuleMark(), depenTSEntity.getParentModuleName());
        KingScriptParser.StartRuleContext kingscriptTree = IndexDTSMerger.gennerParserTree(filePath);
        ParseTreeWalker walker = new ParseTreeWalker();
        KingScriptListrenerImpl listener = listenerMap.get(indexDTSKey);
        listener.setBuildTime(buildTime);
        listener.setModuleClassSet(moduleClassSet);
        walker.walk((ParseTreeListener)listener, (ParseTree)kingscriptTree);
        listener.getMergerBuilder().setParentModuleMark(depenTSEntity.getParentModuleMark());
        listener.getMergerBuilder().setParentModuleName(depenTSEntity.getParentModuleName());
        listener.getMergerBuilder().setTsDepenList(depenTSEntity.getTsDepenList());
        listener.getMergerBuilder().write(this.indexDTSPath);
    }

    public static KingScriptParser.StartRuleContext gennerParserTree(String filePath) {
        CharStream charStreams = null;
        try {
            charStreams = CharStreams.fromPath((Path)Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KingScriptLexer lexer = new KingScriptLexer(charStreams);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        KingScriptParser parser = new KingScriptParser((TokenStream)tokens);
        KingScriptParser.StartRuleContext kingscriptTree = parser.startRule();
        return kingscriptTree;
    }

    public static void main(String[] args) {
        String filePath = "D:\\JavaCode\\bos-corlib\\1008\\bos-corelib\\code\\bos-util\\target\\generated-kingscript\\tsc\\dist\\index.d.ts";
        KingScriptParser.StartRuleContext kingscriptTree = IndexDTSMerger.gennerParserTree(filePath);
        ParseTreeWalker walker = new ParseTreeWalker();
        KingScriptListrenerImpl kingScriptListrener = new KingScriptListrenerImpl();
        walker.walk((ParseTreeListener)kingScriptListrener, (ParseTree)kingscriptTree);
    }
}

