/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.sdk.kingscript.lib.tgz.MergerBuilder;
import kd.sdk.kingscript.lib.tsparser.KingScriptBaseListener;
import kd.sdk.kingscript.lib.tsparser.KingScriptParser;

public class KingScriptListrenerImpl
extends KingScriptBaseListener {
    private MergerBuilder mergerBuilder = new MergerBuilder();
    private Map<String, String> referenceMap = new HashMap<String, String>();
    private List<String> namespaceNameList = new ArrayList<String>();
    private Set<String> namespaceClassSet = new HashSet<String>();
    private Map<String, String> namespaceDataMap = new TreeMap<String, String>();
    private Set<String> moduleClassSet = new HashSet<String>();
    private Long buildTime;
    public static final String SPACES = "  ";
    private static StringBuilder INTERFACE_SPACES = new StringBuilder();
    private static StringBuilder CLASS_SPACES = new StringBuilder();
    private static StringBuilder METHOD_SPACES = new StringBuilder();
    private static StringBuilder COMMENT_SPACES = new StringBuilder();

    public void setModuleClassSet(Set<String> moduleClassSet) {
        this.moduleClassSet = moduleClassSet;
    }

    public void setBuildTime(Long buildTime) {
        this.buildTime = buildTime;
    }

    public MergerBuilder getMergerBuilder() {
        return this.mergerBuilder;
    }

    @Override
    public void enterReferenceDirective(KingScriptParser.ReferenceDirectiveContext ctx) {
        StringBuilder writeSB = new StringBuilder();
        writeSB.append("/// <reference types=\"");
        writeSB.append(ctx.referenceName().getText());
        writeSB.append("\" />");
        this.referenceMap.computeIfAbsent(ctx.referenceName().getText(), k -> writeSB.toString());
        this.mergerBuilder.mergerReference(ctx.referenceName().getText(), writeSB.toString());
    }

    @Override
    public void enterNamespaceBlock(KingScriptParser.NamespaceBlockContext ctx) {
        String currentNPName = ctx.namespaceName().getText();
        this.namespaceNameList.add(currentNPName);
        this.namespaceClassSet = new HashSet<String>();
        this.namespaceDataMap = new TreeMap<String, String>();
    }

    @Override
    public void exitNamespaceBlock(KingScriptParser.NamespaceBlockContext ctx) {
        String namespacePath = String.join((CharSequence)"::", this.namespaceNameList);
        if (null != this.namespaceClassSet && this.namespaceClassSet.size() > 0) {
            this.mergerBuilder.mergerClass(namespacePath, this.namespaceClassSet, this.namespaceDataMap, this.moduleClassSet, this.buildTime);
        }
        if (null != this.namespaceNameList && this.namespaceNameList.size() > 0) {
            this.namespaceNameList.remove(this.namespaceNameList.size() - 1);
        }
        if (null != this.namespaceDataMap && this.namespaceDataMap.size() > 0) {
            this.namespaceDataMap.clear();
        }
        if (null != this.namespaceClassSet && this.namespaceClassSet.size() > 0) {
            this.namespaceClassSet.clear();
        }
    }

    @Override
    public void enterTypeDeclaration(KingScriptParser.TypeDeclarationContext ctx) {
        String typeName = ctx.typeDeclarationName().getText();
        StringBuilder writeSB = new StringBuilder();
        writeSB.append((CharSequence)INTERFACE_SPACES);
        writeSB.append("type ").append(typeName).append(" = ");
        writeSB.append(ctx.typeExpression().getText().replace("&", " & "));
        writeSB.append(";");
        this.namespaceDataMap.put(typeName, writeSB.toString());
    }

    @Override
    public void enterEnumDeclaration(KingScriptParser.EnumDeclarationContext ctx) {
        String enumName = ctx.enumDeclarationName().getText();
        StringBuilder writeSB = new StringBuilder();
        writeSB.append((CharSequence)INTERFACE_SPACES);
        writeSB.append("enum").append(" ");
        writeSB.append(enumName).append(" ").append("{").append(System.lineSeparator());
        List<KingScriptParser.EnumExpressionContext> enumExpList = ctx.enumExpression();
        if (enumExpList != null && enumExpList.size() > 0) {
            enumExpList.forEach(data -> {
                writeSB.append((CharSequence)METHOD_SPACES);
                writeSB.append(data.getText()).append(System.lineSeparator());
            });
        }
        writeSB.append((CharSequence)INTERFACE_SPACES);
        writeSB.append("}");
        this.namespaceClassSet.add(enumName);
        this.namespaceDataMap.put(enumName, writeSB.toString());
    }

    @Override
    public void enterInterfaceBlock(KingScriptParser.InterfaceBlockContext ctx) {
        String interfaceName = ctx.interfaceBlockName().getText();
        StringBuilder interfaceWriteSB = new StringBuilder();
        interfaceWriteSB.append((CharSequence)INTERFACE_SPACES);
        interfaceWriteSB.append("interface").append(" ");
        interfaceWriteSB.append(interfaceName).append(" ");
        KingScriptParser.InterfaceBlockExtendsContext extendsContext = ctx.interfaceBlockExtends();
        if (null != extendsContext) {
            String superInterfaceName = extendsContext.getText();
            interfaceWriteSB.append("extends").append(" ").append(superInterfaceName).append(" ");
            if (superInterfaceName.equals(interfaceName + "_T")) {
                this.namespaceClassSet.add(interfaceName);
            }
        }
        interfaceWriteSB.append("{").append(System.lineSeparator());
        List<KingScriptParser.InterfaceBlockMemberContext> memberList = ctx.interfaceBlockMember();
        if (null != memberList && memberList.size() > 0) {
            memberList.forEach(data -> {
                KingScriptParser.FieldDeclarationContext field;
                KingScriptParser.MethodDeclarationContext method = data.methodDeclaration();
                if (null != method) {
                    StringBuilder writeSB = new StringBuilder();
                    writeSB.append(method.COMMENT() == null ? "" : writeSB.append((CharSequence)COMMENT_SPACES) + method.COMMENT().getText() + System.lineSeparator());
                    writeSB.append((CharSequence)METHOD_SPACES);
                    writeSB.append(method.methodDeclarationName().getText());
                    writeSB.append(method.QUESTION() == null ? "" : method.QUESTION().getText());
                    writeSB.append("(").append(method.paramListDeclaration() == null ? "" : method.paramListDeclaration().getText()).append(")");
                    writeSB.append(":").append(method.returnDeclaration().getText()).append(";");
                    interfaceWriteSB.append((CharSequence)writeSB).append(System.lineSeparator());
                }
                if (null != (field = data.fieldDeclaration())) {
                    StringBuilder writeSB = new StringBuilder();
                    writeSB.append(field.COMMENT() == null ? "" : writeSB.append((CharSequence)COMMENT_SPACES) + field.COMMENT().getText() + System.lineSeparator());
                    writeSB.append((CharSequence)METHOD_SPACES);
                    writeSB.append(field.READONLY() == null ? "" : field.READONLY().getText() + " ");
                    writeSB.append(field.fieldDeclarationName().getText());
                    writeSB.append(":").append(field.classTypeObject().getText()).append(";");
                    interfaceWriteSB.append((CharSequence)writeSB).append(System.lineSeparator());
                }
            });
        }
        interfaceWriteSB.append((CharSequence)INTERFACE_SPACES);
        interfaceWriteSB.append("}");
        this.namespaceDataMap.put(interfaceName, interfaceWriteSB.toString());
    }

    @Override
    public void enterClassBlock(KingScriptParser.ClassBlockContext ctx) {
        String classBlockName = ctx.classBlockName().getText();
        StringBuilder classWriteSB = new StringBuilder();
        classWriteSB.append((CharSequence)CLASS_SPACES);
        classWriteSB.append("class").append(" ");
        classWriteSB.append(classBlockName).append(" ");
        this.namespaceClassSet.add(classBlockName);
        KingScriptParser.ClassBlockExtendsContext extendsContext = ctx.classBlockExtends();
        if (null != extendsContext) {
            String superClassName = extendsContext.getText();
            classWriteSB.append("extends").append(" ").append(superClassName).append(" ");
        }
        classWriteSB.append("{").append(System.lineSeparator());
        List<KingScriptParser.InterfaceBlockMemberContext> memberList = ctx.interfaceBlockMember();
        if (null != memberList && memberList.size() > 0) {
            memberList.forEach(data -> {
                KingScriptParser.FieldDeclarationContext field;
                KingScriptParser.MethodDeclarationContext method = data.methodDeclaration();
                if (null != method) {
                    StringBuilder writeSB = new StringBuilder();
                    writeSB.append(method.COMMENT() == null ? "" : writeSB.append((CharSequence)COMMENT_SPACES) + method.COMMENT().getText() + System.lineSeparator());
                    writeSB.append((CharSequence)METHOD_SPACES);
                    writeSB.append(method.STATIC() == null ? "" : method.STATIC().getText() + " ");
                    writeSB.append(method.methodDeclarationName().getText());
                    writeSB.append(method.QUESTION() == null ? "" : method.QUESTION().getText());
                    writeSB.append("(").append(method.paramListDeclaration() == null ? "" : method.paramListDeclaration().getText()).append(")");
                    writeSB.append(":").append(method.returnDeclaration().getText()).append(";");
                    classWriteSB.append((CharSequence)writeSB).append(System.lineSeparator());
                }
                if (null != (field = data.fieldDeclaration())) {
                    StringBuilder writeSB = new StringBuilder();
                    writeSB.append(field.COMMENT() == null ? "" : writeSB.append((CharSequence)COMMENT_SPACES) + field.COMMENT().getText() + System.lineSeparator());
                    writeSB.append((CharSequence)METHOD_SPACES);
                    writeSB.append(field.STATIC() == null ? "" : field.STATIC().getText() + " ");
                    writeSB.append(field.READONLY() == null ? "" : field.READONLY().getText() + " ");
                    writeSB.append(field.fieldDeclarationName().getText());
                    writeSB.append(":").append(field.classTypeObject().getText()).append(";");
                    classWriteSB.append((CharSequence)writeSB).append(System.lineSeparator());
                }
            });
        }
        classWriteSB.append((CharSequence)INTERFACE_SPACES);
        classWriteSB.append("}");
        this.namespaceDataMap.put(classBlockName, classWriteSB.toString());
    }

    static {
        INTERFACE_SPACES.append(SPACES);
        INTERFACE_SPACES.append(SPACES);
        INTERFACE_SPACES.append(SPACES);
        INTERFACE_SPACES.append(SPACES);
        INTERFACE_SPACES.append(SPACES);
        INTERFACE_SPACES.append(SPACES);
        CLASS_SPACES.append((CharSequence)INTERFACE_SPACES);
        METHOD_SPACES.append((CharSequence)INTERFACE_SPACES);
        METHOD_SPACES.append(SPACES);
        METHOD_SPACES.append(SPACES);
        COMMENT_SPACES.append(SPACES);
        COMMENT_SPACES.append(SPACES);
        COMMENT_SPACES.append(SPACES);
        COMMENT_SPACES.append(SPACES);
    }
}

