/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.tgz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.sdk.kingscript.lib.tgz.DependenciesTSEntity;
import org.apache.commons.lang3.StringUtils;

public class ParseJavaJar {
    public static final String SDK_USE_CONFIG_PARENT_MODULE_NAME = "parent_module_name";
    public static final String SDK_USE_CONFIG_SUB_MODULE_NAME = "sub_module_name";
    public static final String SDK_USE_CONFIG_PARENT_MODULE_MARK = "parent_module_mark";
    public static final String SDK_MODULE_CONFIG = "sdk_module_config";
    public static final String SDK_USE_CONFIG_TS_TYPE = "ts_type";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DependenciesTSEntity getTgzForJar(String sourceFileJar, String targetOut) {
        DependenciesTSEntity sdkDataWithJavaJarDto = new DependenciesTSEntity();
        ArrayList<String> sdkOutPathList = new ArrayList<String>();
        sdkDataWithJavaJarDto.setSdkOutPathList(sdkOutPathList);
        try (JarFile jarFile = new JarFile(sourceFileJar);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("script/")) continue;
                if (entry.getName().startsWith("script/@") && entry.getName().endsWith(".tgz")) {
                    ParseJavaJar.extractSDKWithJavaLib(jarFile, entry, targetOut, sdkOutPathList);
                }
                if (!entry.getName().endsWith(SDK_MODULE_CONFIG)) continue;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
                    Throwable throwable = null;
                    try {
                        ParseJavaJar.extractConfigWithJavaLib(reader, sdkDataWithJavaJarDto);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                    return sdkDataWithJavaJarDto;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void extractSDKWithJavaLib(JarFile jarFile, JarEntry entry, String targetOut, List<String> sdkOutPathList) {
        String tgzFileName = new File(entry.getName()).getName();
        String outTgz = targetOut + File.separator + tgzFileName;
        try (InputStream inputStream = jarFile.getInputStream(entry);
             FileOutputStream outputStream = new FileOutputStream(new File(outTgz));){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        sdkOutPathList.add(outTgz);
    }

    public static void extractConfigWithJavaLib(BufferedReader reader, DependenciesTSEntity sdkDataWithJavaJarDto) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line)) continue;
                String[] valueArr = line.split("=");
                String paramKey = valueArr[0];
                if (SDK_USE_CONFIG_PARENT_MODULE_NAME.equals(paramKey)) {
                    if (valueArr.length < 2) {
                        throw new RuntimeException("sdk_module_config:parent_module_name : null");
                    }
                    sdkDataWithJavaJarDto.setParentModuleName(valueArr[1]);
                    continue;
                }
                if (SDK_USE_CONFIG_SUB_MODULE_NAME.equals(paramKey)) {
                    if (valueArr.length < 2) {
                        throw new RuntimeException("sdk_module_config:sub_module_name : null");
                    }
                    sdkDataWithJavaJarDto.setSubModuleName(valueArr[1]);
                    continue;
                }
                if (SDK_USE_CONFIG_PARENT_MODULE_MARK.equals(paramKey)) {
                    if (valueArr.length < 2) {
                        throw new RuntimeException("sdk_module_config:parent_module_mark : null");
                    }
                    sdkDataWithJavaJarDto.setParentModuleMark(valueArr[1]);
                    continue;
                }
                if (!SDK_USE_CONFIG_TS_TYPE.equals(paramKey)) continue;
                if (valueArr.length < 2) {
                    throw new RuntimeException("sdk_module_config:ts_type : null");
                }
                sdkDataWithJavaJarDto.setTsType(valueArr[1]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

