/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.lib.version;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import java.util.Map;
import java.util.function.Supplier;
import kd.sdk.kingscript.engine.EvalContext;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.ScriptPathFormat;

public final class VersionedModuleLoader {
    public static JSModuleRecord resolveImport(String canonicalPath, Supplier<JSModuleRecord> importResolver) {
        Map<String, JSModuleRecord> moduleMap = GlobalCache.get().getESModuleMap();
        JSModuleRecord imported = moduleMap.get(canonicalPath);
        if (imported != null) {
            EvalContext.get().addImported(canonicalPath);
            String scriptPath = imported.getSource().getPath();
            LibFileSystem libFileSystem = KingScriptEngine.getCurrent().unwrap(KingScriptEngineImpl.class).getLibFileSystem();
            if (!libFileSystem.hasUpdated(scriptPath)) {
                return imported;
            }
        }
        imported = importResolver.get();
        moduleMap.put(canonicalPath, imported);
        EvalContext.get().addImported(canonicalPath);
        return imported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSModuleRecord loadModule(Source source, Map<String, JSModuleRecord> moduleMap, JSModuleData moduleData, JSModuleLoader moduleLoader) {
        if (!source.isCached()) {
            return new JSModuleRecord(moduleData, moduleLoader);
        }
        String newVersionPath = source.getName();
        String canonicalPath = ScriptPathFormat.format(source.getPath());
        Map<String, String> esModuleLastVersionedPathMap = GlobalCache.get().getESModuleLastVersionedPathMap();
        Source source2 = source;
        synchronized (source2) {
            String oldVersionPath = esModuleLastVersionedPathMap.get(canonicalPath);
            if (oldVersionPath == null) {
                esModuleLastVersionedPathMap.put(canonicalPath, newVersionPath);
            } else if (!oldVersionPath.equals(newVersionPath)) {
                moduleMap.remove(canonicalPath);
                esModuleLastVersionedPathMap.put(canonicalPath, newVersionPath);
            }
        }
        return moduleMap.computeIfAbsent(canonicalPath, key -> new JSModuleRecord(moduleData, moduleLoader));
    }
}

