/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.log;

import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.log.DummyLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Logs {
    public static String KINGSCRIPT_LOG_NAME = "KingScript";
    private static boolean enabled = true;

    @ConfigurableItem(desc="\u5f00\u542f\u5f15\u64ce\u5185\u90e8\u65e5\u5fd7")
    public static void setEngineLogEnabled(boolean enabled) {
        Logs.enabled = enabled;
    }

    public static boolean isEngineLogEnabled() {
        return enabled;
    }

    public static Logger getLogger() {
        return Logs.doGetLogger(KINGSCRIPT_LOG_NAME);
    }

    public static Logger getLogger(Class<?> clsName) {
        return Logs.doGetLogger(clsName.getName());
    }

    public static Logger getLogger(String name) {
        return Logs.doGetLogger(name);
    }

    private static Logger doGetLogger(String name) {
        return enabled ? LoggerFactory.getLogger((String)name) : DummyLogger.INSTANCE;
    }
}

