/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.mixture;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.sdk.annotation.SdkScriptBound;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.host.ScriptProxyFactory;
import kd.sdk.kingscript.mixture.Mixture;
import kd.sdk.kingscript.mixture.MixtureInterceptor;
import kd.sdk.kingscript.mixture.MixtureProxy;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@Deprecated
public final class MixtureFactory {
    private static final String SCRIPT_CLASS_SUFFIX = "__kingscript__mixture";
    private static final Map<String, Class<?>> scriptClassMap = new ConcurrentHashMap();

    public static boolean isTypeOf(Object mixture, Class<?> typeCls) {
        InvocationHandler h;
        if (typeCls.isAssignableFrom(mixture.getClass())) {
            return true;
        }
        if (Proxy.isProxyClass(mixture.getClass()) && (h = Proxy.getInvocationHandler(mixture)) instanceof MixtureProxy) {
            MixtureProxy proxy = (MixtureProxy)h;
            return proxy.isTypeOf(typeCls);
        }
        return false;
    }

    public static <T> T tryAsType(Object mixture, Class<T> typeCls) {
        InvocationHandler h;
        if (typeCls.isAssignableFrom(mixture.getClass())) {
            return (T)mixture;
        }
        if (Proxy.isProxyClass(mixture.getClass()) && (h = Proxy.getInvocationHandler(mixture)) instanceof MixtureProxy) {
            MixtureProxy proxy = (MixtureProxy)h;
            Object javaObject = proxy.mixture.asJavaObject();
            if (typeCls.isAssignableFrom(javaObject.getClass())) {
                return (T)javaObject;
            }
        }
        return null;
    }

    public static <T> T createMixtureProxy(MixtureProxy proxy) {
        return ScriptProxyFactory.createPluginProxy(proxy.getScriptPath(), proxy.getAutoDebugEngineCreator());
    }

    @SdkScriptBound(value="/resources/asset/engine/initialize_script.js")
    public static <T> T createHostMixture(String clsName) {
        try {
            return (T)MixtureFactory.getMixtureClass(clsName).newInstance();
        }
        catch (Exception e) {
            throw ScriptException.wrap(e);
        }
    }

    public static Class<?> getMixtureClass(String clsName) {
        Class ret = scriptClassMap.get(clsName);
        if (ret == null) {
            ret = scriptClassMap.computeIfAbsent(clsName, k -> MixtureFactory.genMixtureClass(clsName));
        }
        return ret;
    }

    public static boolean isMixtureObject(Object object) {
        return MixtureFactory.isMixtureClass(object.getClass());
    }

    public static boolean isMixtureClass(Class<?> cls) {
        return Mixture.class.isAssignableFrom(cls) && cls.getSimpleName().endsWith(SCRIPT_CLASS_SUFFIX);
    }

    private static Class<?> genMixtureClass(String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            return MixtureFactory.genMixtureClass(cls, SCRIPT_CLASS_SUFFIX, null, new Class[0]);
        }
        catch (Exception e) {
            throw ScriptException.wrap(e);
        }
    }

    static Class<?> genMixtureClass(Class<?> cls, String scriptClassSuffix, Function<DynamicType.Builder<?>, DynamicType.Builder<?>> customBuildFunc, Class<?> ... interfaces) {
        try {
            if (MixtureFactory.isMixtureClass(cls)) {
                return cls;
            }
            String name = cls.getName() + scriptClassSuffix;
            MethodDelegation methodDelegation = MethodDelegation.to(MixtureInterceptor.class);
            ElementMatcher.Junction methodMatcher = ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(Mixture.class)));
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition bb = new ByteBuddy().subclass(cls).name(name).method((ElementMatcher)methodMatcher).intercept((Implementation)methodDelegation);
            if (interfaces != null) {
                for (Class<?> clsInterface : interfaces) {
                    bb = bb.implement(new Type[]{clsInterface}).intercept((Implementation)methodDelegation);
                }
            }
            if (customBuildFunc != null) {
                bb = customBuildFunc.apply((DynamicType.Builder<?>)bb);
            }
            bb = bb.defineField("__scriptObject", Object.class, 2).implement(new Type[]{Mixture.class}).intercept((Implementation)FieldAccessor.ofBeanProperty());
            Class ret = bb.make().load(Thread.currentThread().getContextClassLoader()).getLoaded();
            return ret;
        }
        catch (Exception e) {
            throw ScriptException.wrap(e);
        }
    }
}

