/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.mixture;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.mixture.CustomInterceptor;
import kd.sdk.kingscript.mixture.Mixture;
import kd.sdk.kingscript.mixture.MixtureScriptCallContext;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;

public final class MixtureInterceptor {
    private static boolean equalsMethod(Method mixMethod, Method mixSuperMethod) {
        int c;
        if (mixMethod.getName().equals(mixSuperMethod.getName()) && (c = mixMethod.getParameterCount()) == mixSuperMethod.getParameterCount()) {
            if (c > 0) {
                for (int i = 0; i < c; ++i) {
                    if (mixMethod.getParameterTypes()[i] == mixSuperMethod.getParameterTypes()[i]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @RuntimeType
    public static Object intercept(@This Object mixObject, @Origin Method mixSuperMethod, @AllArguments Object[] args, @SuperCall Callable<Object> mixSuperCallable) throws Throwable {
        String name;
        Function function;
        String methodName = mixSuperMethod.getName();
        if (methodName.startsWith("__") || methodName.endsWith("__scriptObject")) {
            return mixSuperCallable.call();
        }
        MixtureScriptCallContext ctx = MixtureScriptCallContext.get();
        if (ctx != null && MixtureInterceptor.equalsMethod(ctx.getCallMethod(), mixSuperMethod)) {
            return MixtureInterceptor.callJavaMethod(mixObject, mixSuperMethod, args, mixSuperCallable);
        }
        Map scriptObject = (Map)((Mixture)mixObject).get__scriptObject();
        if (scriptObject != null && (function = (Function)scriptObject.get(name = mixSuperMethod.getName())) != null) {
            return function.apply(args);
        }
        return MixtureInterceptor.callJavaMethod(mixObject, mixSuperMethod, args, mixSuperCallable);
    }

    private static Object callJavaMethod(Object mixObject, Method mixSuperMethod, Object[] args, Callable<Object> callable) throws Throwable {
        try {
            if (mixObject instanceof CustomInterceptor) {
                return ((CustomInterceptor)mixObject).__intercept(mixSuperMethod, args, callable);
            }
            return callable.call();
        }
        catch (InvocationTargetException e) {
            throw ScriptException.wrap(e);
        }
    }
}

