/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.mixture;

import java.lang.reflect.Method;

public final class MixtureScriptCallContext
implements AutoCloseable {
    private static final ThreadLocal<MixtureScriptCallContext> th = new ThreadLocal();
    private final MixtureScriptCallContext parent;
    private final Method callMethod;

    public static MixtureScriptCallContext setup(Method callMethod) {
        return new MixtureScriptCallContext(callMethod);
    }

    public static MixtureScriptCallContext get() {
        return th.get();
    }

    private MixtureScriptCallContext(Method callMethod) {
        this.callMethod = callMethod;
        this.parent = th.get();
        th.set(this);
    }

    public Method getCallMethod() {
        return this.callMethod;
    }

    @Override
    public void close() {
        MixtureScriptCallContext ctx = th.get();
        if (ctx != null && ctx.parent != null) {
            th.set(this.parent);
        } else {
            th.remove();
        }
    }
}

