/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.cost;

import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.stat.Stat;
import org.slf4j.Logger;

public class Cost
implements AutoCloseable {
    private static final Logger logger = Logs.getLogger();
    private long cost;
    private long beginTS = System.currentTimeMillis();
    private final String type;
    private final String name;
    private final String accountId;
    private String exceptionContext;
    private transient boolean checkWarn;
    private transient boolean logOnClose;
    public static final String COMMON_SCRIPTPATH = "common_scriptpath";
    private String scriptPath = "common_scriptpath";

    public Cost(String type, String name) {
        this.type = type;
        this.name = name;
        this.accountId = AccountProvider.get().getAccountId();
    }

    public Cost(String type, String name, String scriptPath) {
        this(type, name);
        this.scriptPath = scriptPath;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String toString() {
        return "Cost{type='" + this.type + '\'' + ", cost=" + this.cost + ", name='" + this.name + '\'' + ", accountId=" + this.accountId + '}';
    }

    public Cost logOnClose() {
        this.logOnClose = true;
        return this;
    }

    public Cost warnOnClose() {
        this.checkWarn = true;
        return this;
    }

    @Override
    public void close() {
        this.cost = System.currentTimeMillis() - this.beginTS;
        if (this.logOnClose) {
            logger.info(this.toString());
        }
        if (this.checkWarn) {
            Stat.warnCost(this);
        }
        if (this.accountId != null) {
            Stat.stat(this);
        }
    }

    public long getCost() {
        return this.cost;
    }

    public void setExceptionContext(String exceptionContext) {
        this.exceptionContext = exceptionContext;
    }

    public String getExceptionContext() {
        return this.exceptionContext;
    }
}

