/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.cost;

import kd.sdk.kingscript.monitor.cost.Cost;

public final class CostData {
    private final String type;
    private int times;
    private long totalCost;
    private long minCost = Long.MAX_VALUE;
    private long maxCost;
    private String costName;
    private String exceptionContext;

    public CostData(String type) {
        this.type = type;
    }

    public void aggregate(CostData cd) {
        this.times += cd.times;
        this.totalCost += cd.totalCost;
        if (cd.maxCost > this.maxCost) {
            this.maxCost = cd.maxCost;
        }
        if (cd.minCost < this.minCost) {
            this.minCost = cd.minCost;
        }
    }

    public void aggregate(Cost cost) {
        ++this.times;
        this.costName = cost.getName();
        this.exceptionContext = cost.getExceptionContext();
        long ts = cost.getCost();
        this.totalCost += ts;
        if (ts > this.maxCost) {
            this.maxCost = ts;
        }
        if (ts < this.minCost) {
            this.minCost = ts;
        }
    }

    public String getType() {
        return this.type;
    }

    public int getTimes() {
        return this.times;
    }

    public long getMaxCost() {
        return this.maxCost;
    }

    public long getMinCost() {
        return this.minCost;
    }

    public long getTotalCost() {
        return this.totalCost;
    }

    public String getCostName() {
        return this.costName;
    }

    public String getExceptionContext() {
        return this.exceptionContext;
    }

    public String toString() {
        return "{type=" + this.type + ", times=" + this.times + ", cost=" + this.totalCost + '}';
    }
}

