/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.cost.probe.checker;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kd.sdk.kingscript.exception.LimitExceededException;
import kd.sdk.kingscript.log.Loggable;
import kd.sdk.kingscript.monitor.cost.probe.action.LimitExceededAction;
import kd.sdk.kingscript.monitor.cost.probe.checker.LimitExceededChecker;
import kd.sdk.kingscript.monitor.cost.probe.config.DefaultProbeItemConfig;
import kd.sdk.kingscript.monitor.cost.probe.config.ProbeItemConfig;
import kd.sdk.kingscript.monitor.cost.probe.data.ProbeData;

public class DefaultLimitExceededChecker<T extends ProbeData, C extends DefaultProbeItemConfig>
implements LimitExceededChecker<T, C>,
Loggable {
    public static final DefaultLimitExceededChecker INSTANCE = new DefaultLimitExceededChecker();
    private static Map<String, Object> instanceCache = new ConcurrentHashMap<String, Object>(8);
    private static Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>(8);
    private static final String METHOD = "check";
    private static final String CLASS_NAME = "className";
    private static final Object EMPTY_SECURITY_CONFIG = new Object();

    @Override
    public void check(T item, C config) throws LimitExceededException {
        if (!this.customSecurityCheck(item, config)) {
            return;
        }
        int maxTimes = ((DefaultProbeItemConfig)config).getMaxTimes();
        if (maxTimes > 0 && ((ProbeData)item).getTimes() > maxTimes) {
            LimitExceededAction.getAction(((ProbeItemConfig)config).getCheckLevel()).onLimitExceeded("Calling \"" + ((ProbeData)item).getName() + "\" exceeded the limit (" + ((ProbeData)item).getTimes() + ">" + maxTimes + ").");
        }
    }

    private boolean customSecurityCheck(T item, C config) throws LimitExceededException {
        Map<String, Object> customSecurityConfig = ((DefaultProbeItemConfig)config).getCustomSecurityController();
        if (customSecurityConfig == null) {
            return true;
        }
        String aClassName = (String)customSecurityConfig.get(CLASS_NAME);
        if (aClassName != null && aClassName.length() > 0) {
            Object instance = instanceCache.get(aClassName);
            AtomicReference aclassReference = new AtomicReference();
            if (instance == null) {
                instance = instanceCache.computeIfAbsent(aClassName, k -> {
                    try {
                        Class<?> aClass = Class.forName(aClassName);
                        aclassReference.set(aClass);
                        return aClass.newInstance();
                    }
                    catch (Throwable e) {
                        logger.error("init class[" + aClassName + "]error", e);
                        return EMPTY_SECURITY_CONFIG;
                    }
                });
            }
            if (instance == EMPTY_SECURITY_CONFIG) {
                return true;
            }
            Method invokeMethod = methodCache.get(aClassName + "#" + METHOD);
            if (invokeMethod == null) {
                invokeMethod = methodCache.computeIfAbsent(aClassName + "#" + METHOD, k -> {
                    try {
                        Method[] declaredMethods;
                        Class<?> cls = (Class<?>)aclassReference.get();
                        if (cls == null) {
                            cls = Class.forName(aClassName);
                        }
                        for (Method method : declaredMethods = cls.getDeclaredMethods()) {
                            if (!METHOD.equals(method.getName())) continue;
                            return method;
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        logger.error("get Method[check]error", e);
                        return null;
                    }
                });
            }
            if (invokeMethod == null) {
                return true;
            }
            try {
                Boolean result = (Boolean)invokeMethod.invoke(instance, customSecurityConfig);
                if (!result.booleanValue()) {
                    LimitExceededAction.getAction(((ProbeItemConfig)config).getCheckLevel()).onLimitExceeded("Calling \"" + ((ProbeData)item).getName() + "\" not pass the customSecurityConfig[" + aClassName + "]'s check!");
                    return false;
                }
            }
            catch (Throwable e) {
                if (e instanceof LimitExceededException) {
                    throw (LimitExceededException)e;
                }
                throw new LimitExceededException("invoke class '" + aClassName + "' method 'check' error:" + e);
            }
        }
        return true;
    }
}

