/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.stat;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Cost;
import kd.sdk.kingscript.monitor.cost.CostData;
import kd.sdk.kingscript.monitor.cost.EngineCostType;
import kd.sdk.kingscript.monitor.stat.StatFormatter;
import org.slf4j.Logger;

public final class Stat {
    @ConfigurableItem(desc="\u7edf\u8ba1\u8017\u8d39\u8b66\u544a\u9608\u503c")
    public static String KINGSCRIPT_COST_EXCEED = "kingscript.stat.cost.exceed";
    private static long exceedCostTS = 30000L;
    private static final Logger logger = Logs.getLogger();
    private static final Map<String, Map<String, Map<String, CostData>>> totalMap = new ConcurrentHashMap<String, Map<String, Map<String, CostData>>>();
    private static final Map<String, Map<String, Map<String, CostData>>> consumeTempMap = new ConcurrentHashMap<String, Map<String, Map<String, CostData>>>();
    private static final Object lock = new Object();
    private static final List<Cost> tempList = new LinkedList<Cost>();

    private static void refreshExceedCost() {
        try {
            exceedCostTS = Long.parseLong(System.getProperty(KINGSCRIPT_COST_EXCEED, String.valueOf(exceedCostTS)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = lock;
        synchronized (object) {
            totalMap.clear();
            consumeTempMap.clear();
            tempList.clear();
        }
    }

    public static void log() {
        logger.info(StatFormatter.format(Stat.getTotalStatAggregated(), "log stat"));
        GlobalCache.get().log();
    }

    public static void warnCost(Cost cost) {
        if (cost.getCost() >= exceedCostTS) {
            String msg = "[" + cost.getType() + "] " + cost.getName() + " cost exceeded warning: " + cost.getCost() + "ms (>=" + exceedCostTS + ")";
            Exception e = new Exception(msg);
            logger.warn(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stat(Cost cost) {
        Object object = lock;
        synchronized (object) {
            tempList.add(cost);
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, Map<String, CostData>>> consumeForReport() {
        Map<String, Map<String, Map<String, CostData>>> map = consumeTempMap;
        synchronized (map) {
            HashMap<String, Map<String, Map<String, CostData>>> map2 = new HashMap<String, Map<String, Map<String, CostData>>>(consumeTempMap);
            consumeTempMap.clear();
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CostData> getTotalStatAggregated() {
        TreeMap<String, CostData> map = new TreeMap<String, CostData>();
        Map<String, Map<String, Map<String, CostData>>> map2 = totalMap;
        synchronized (map2) {
            for (Map<String, Map<String, CostData>> typeOfCostData : totalMap.values()) {
                for (Map.Entry<String, Map<String, CostData>> typeOfCostDataEntry : typeOfCostData.entrySet()) {
                    String type = typeOfCostDataEntry.getKey();
                    Map<String, CostData> scriptPathOfCostData = typeOfCostDataEntry.getValue();
                    for (Map.Entry<String, CostData> item : scriptPathOfCostData.entrySet()) {
                        String scriptPath = item.getKey();
                        CostData cd = (CostData)map.get(scriptPath);
                        if (cd == null) {
                            cd = new CostData(type);
                            map.put(type, cd);
                        }
                        cd.aggregate(item.getValue());
                    }
                }
            }
        }
        return map;
    }

    private static void aggregate() {
        Stat.aggregate2Map(tempList, consumeTempMap);
        tempList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void aggregate2Map(List<Cost> costList, Map<String, Map<String, Map<String, CostData>>> accountCostDatas) {
        Map<String, Map<String, Map<String, CostData>>> map = accountCostDatas;
        synchronized (map) {
            for (Cost cost : costList) {
                if (!cost.getType().equals(EngineCostType.engine_eval.name())) continue;
                Map typeCostDatas = accountCostDatas.computeIfAbsent(cost.getAccountId(), k -> new HashMap());
                Map scriptPathCostDatas = typeCostDatas.computeIfAbsent(cost.getType(), k -> new HashMap());
                CostData cd = scriptPathCostDatas.computeIfAbsent(cost.getScriptPath(), k -> new CostData(cost.getType()));
                cd.aggregate(cost);
            }
        }
    }

    static {
        Thread thread = new Thread(() -> {
            while (true) {
                Stat.refreshExceedCost();
                Object object = lock;
                synchronized (object) {
                    try {
                        lock.wait();
                        Stat.aggregate();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("KingScript-Monitor-Stat");
        thread.start();
    }
}

