/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.timeout;

import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.exception.ScriptTimeoutException;
import kd.sdk.kingscript.monitor.timeout.ApiCallTimeoutException;
import org.graalvm.polyglot.PolyglotException;

public final class TimeoutChecker
implements AutoCloseable {
    public static final String TIMEOUT_MESSAGE_KEY = "timeout_message_key";
    @ConfigurableItem(desc="\u811a\u672capi\u8d85\u65f6")
    public static final String SCRIPT_EVAL_TIMEOUT_CONFIG_KEY = "kingscript.script.eval.timeout";
    public static final long SCRIPT_EVAL_TIMEOUT_DEFAULT_VALUE = 1800000L;
    @ConfigurableItem(desc="\u811a\u672capi\u8d85\u65f6-debug\u8c03\u8bd5\u6a21\u5f0f")
    public static final String SCRIPT_EVAL_DEBUG_TIMEOUT_CONFIG_KEY = "kingscript.script.eval.debug.timeout";
    public static final long SCRIPT_EVAL_DEBUG_TIMEOUT_DEFAULT_VALUE = 3600000L;
    @ConfigurableItem(desc="java api\u8d85\u65f6")
    public static final String JAVA_CALL_TIMEOUT_CONFIG_KEY = "kingscript.java.call.timeout";
    public static final long JAVA_CALL_TIMEOUT_DEFAULT_VALUE = 1800000L;
    private static ThreadLocal<TimeoutChecker> th = new ThreadLocal();
    private TimeoutChecker parent = th.get();
    private long timeout;
    private long begin;

    public static long getDefaultScriptEvalTimeout() {
        return Long.parseLong(System.getProperty(SCRIPT_EVAL_TIMEOUT_CONFIG_KEY, String.valueOf(1800000L)));
    }

    public static long getDefaultScriptEvalDebugTimeout() {
        return Long.parseLong(System.getProperty(SCRIPT_EVAL_DEBUG_TIMEOUT_CONFIG_KEY, String.valueOf(3600000L)));
    }

    public static long getDefaultJavaCallTimeout() {
        return Long.parseLong(System.getProperty(JAVA_CALL_TIMEOUT_CONFIG_KEY, String.valueOf(1800000L)));
    }

    public static TimeoutChecker setupJavaCall() {
        return TimeoutChecker.setupJavaCall(TimeoutChecker.getDefaultJavaCallTimeout());
    }

    public static TimeoutChecker setupJavaCall(long timeout) {
        return new TimeoutChecker(timeout);
    }

    public static boolean checkIfSetup() {
        TimeoutChecker timeoutChecker = th.get();
        if (timeoutChecker != null) {
            timeoutChecker.check();
            return true;
        }
        return false;
    }

    public static TimeoutChecker get() {
        return th.get();
    }

    private TimeoutChecker(long timeout) {
        this.timeout = timeout;
        this.begin = System.currentTimeMillis();
    }

    public void check() {
        block4: {
            long used = System.currentTimeMillis() - this.begin;
            if (used > this.timeout) {
                throw new ApiCallTimeoutException("Execute timeout: " + used + ">" + this.timeout + "ms");
            }
            KingScriptContext ctx = KingScriptContext.get();
            if (ctx != null) {
                try {
                    ctx.getContext().safepoint();
                }
                catch (PolyglotException e) {
                    if (!e.isInterrupted() && !e.isCancelled()) break block4;
                    throw new ScriptTimeoutException("Script timeout interrupted: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.parent == null) {
            th.remove();
        } else {
            th.set(this.parent);
        }
    }
}

