/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.timeout.service;

import java.util.ArrayList;
import java.util.List;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.timeout.service.TimeoutConfig;
import org.slf4j.Logger;

public class TimeoutConfigService {
    @ConfigurableItem(desc="monitor timeout config \u914d\u7f6e")
    public static final String TIMEOUT_CONFIG = "kingscript.monitor.timeout.config";
    @ConfigurableItem(desc="monitor timeout config  interval\u914d\u7f6e(ms)")
    public static final String INTERVAL = "kingscript.monitor.timeout.config.interval";
    private static long ts_interval = 60000L;
    private static final Logger logger = Logs.getLogger();
    private static final Object lock = new Object();
    private static volatile boolean terminal = false;
    private static List<TimeoutConfig> timeoutConfigs;

    private static List<TimeoutConfig> createTimeoutConfigs() {
        ArrayList<TimeoutConfig> list = new ArrayList<TimeoutConfig>();
        System.setProperty(TIMEOUT_CONFIG, "kd.bos.kingscript.console.control.cache.ScriptPathSecurityCache");
        String timeoutConfigs = System.getProperty(TIMEOUT_CONFIG);
        if (timeoutConfigs != null) {
            for (String s : timeoutConfigs.split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                try {
                    Class<?> cls = Class.forName(s);
                    list.add((TimeoutConfig)cls.newInstance());
                }
                catch (Exception e) {
                    logger.warn("Create monitor timeout config failed: " + s + ", cause by" + e.getMessage(), (Throwable)e);
                }
            }
        }
        logger.info("Create monitor timeout configs: " + list);
        return list;
    }

    public static void preheat() {
        timeoutConfigs = TimeoutConfigService.createTimeoutConfigs();
        for (TimeoutConfig timeoutConfig : timeoutConfigs) {
            try {
                timeoutConfig.preheat();
            }
            catch (Exception e) {
                logger.error(timeoutConfig + " timeout config error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        logger.info("Stop monitor timeout config service...");
        terminal = true;
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }
}

