/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.timeout.service;

import com.oracle.truffle.polyglot.PolyglotContextImpl;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import kd.sdk.kingscript.engine.KingScriptContext;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.exception.ScriptTimeoutException;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.timeout.service.TimeoutInterrupter;
import org.graalvm.polyglot.Context;
import org.slf4j.Logger;

class TimeoutInterrupterImpl
implements TimeoutInterrupter {
    private static final Logger logger = Logs.getLogger();
    private final Context context;
    private final String engineName;
    private volatile boolean terminated = false;
    private volatile boolean started = false;
    private volatile boolean checking = false;
    private volatile boolean interrupted = true;
    private final Object interruptedLock = new Object();
    private volatile String timeoutMessage = null;
    private long timeout;
    private volatile long beginTimeMillis;
    private String scriptName;

    TimeoutInterrupterImpl(String engineName, Context context) {
        this.context = context;
        this.engineName = engineName;
    }

    @Override
    public void run() {
        if (!this.terminated && this.started && !this.checking) {
            this.checking = true;
            try {
                this.check();
            }
            finally {
                this.checking = false;
            }
        }
    }

    @Override
    public void onTimeout() {
        if (this.timeoutMessage != null) {
            ScriptTimeoutException e = new ScriptTimeoutException(this.timeoutMessage);
            this.timeoutMessage = null;
            this.resume();
            throw e;
        }
    }

    private void resume() {
        Context context = KingScriptContext.get().getContext();
        try {
            Field field = context.getClass().getDeclaredField("receiver");
            field.setAccessible(true);
            PolyglotContextImpl receiver = (PolyglotContextImpl)field.get(context);
            receiver.resumeInterrupt();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        block15: {
            try {
                this.timeoutMessage = null;
                if (this.remainTimeMillis() >= 0L) break block15;
                this.started = false;
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                String newName = oldName + '#' + this.engineName + '#' + this.scriptName + '#' + System.currentTimeMillis();
                currentThread.setName(newName);
                try {
                    this.timeoutMessage = "KingScript execute timeout(>" + this.timeout + "ms): " + this.scriptName;
                    logger.warn(this.timeoutMessage);
                    Object object = this.interruptedLock;
                    synchronized (object) {
                        this.interrupted = false;
                    }
                    this.context.interrupt(Duration.ofMillis(Long.MAX_VALUE));
                    object = this.interruptedLock;
                    synchronized (object) {
                        this.interrupted = true;
                        this.interruptedLock.notify();
                    }
                }
                finally {
                    currentThread.setName(oldName);
                }
            }
            catch (TimeoutException currentThread) {
            }
            catch (Exception e) {
                Object object = this.interruptedLock;
                synchronized (object) {
                    this.interrupted = true;
                    this.interruptedLock.notify();
                }
                throw ScriptException.wrap(e);
            }
        }
    }

    @Override
    public void startTiming(String scriptName, long timeout) {
        this.beginTimeMillis = System.currentTimeMillis();
        this.scriptName = scriptName;
        this.timeout = timeout;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTiming() {
        this.started = false;
        if (!this.interrupted) {
            Object object = this.interruptedLock;
            synchronized (object) {
                if (!this.interrupted) {
                    try {
                        this.interruptedLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public boolean isStartTiming() {
        return !this.terminated && this.started;
    }

    @Override
    public long remainTimeMillis() {
        if (this.beginTimeMillis == 0L) {
            return 0L;
        }
        return this.timeout - (System.currentTimeMillis() - this.beginTimeMillis);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void destroy() {
        this.terminated = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.terminated;
    }
}

