/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.pool;

import java.util.LinkedList;
import kd.sdk.kingscript.pool.BabelTranspilerProxy;
import kd.sdk.kingscript.thread.local.MockThreadLocal;
import kd.sdk.kingscript.transpiler.BabelTranspiler;

final class BabelTranspilerPool {
    private final LinkedList<BabelTranspilerProxy> freeList = new LinkedList();
    private final LinkedList<BabelTranspilerProxy> usingList = new LinkedList();
    private final MockThreadLocal<BabelTranspilerProxy> thLastFree = new MockThreadLocal();
    private final BabelTranspiler protoTranspiler;

    BabelTranspilerPool(BabelTranspiler protoTranspiler) {
        this.protoTranspiler = protoTranspiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BabelTranspiler acquire() {
        BabelTranspilerProxy transpiler = this.thLastFree.get();
        LinkedList<BabelTranspilerProxy> linkedList = this.freeList;
        synchronized (linkedList) {
            if (transpiler != null && this.freeList.contains(transpiler)) {
                this.thLastFree.remove();
                this.freeList.remove(transpiler);
            } else {
                transpiler = this.freeList.isEmpty() ? new BabelTranspilerProxy(BabelTranspiler.create(this.protoTranspiler), this) : this.freeList.removeFirst();
            }
        }
        linkedList = this.usingList;
        synchronized (linkedList) {
            this.usingList.add(transpiler);
        }
        return transpiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(BabelTranspilerProxy transpiler) {
        LinkedList<BabelTranspilerProxy> linkedList = this.usingList;
        synchronized (linkedList) {
            this.usingList.remove(transpiler);
        }
        linkedList = this.freeList;
        synchronized (linkedList) {
            transpiler = new BabelTranspilerProxy(transpiler.getTranspiler(), this);
            this.freeList.addFirst(transpiler);
            this.thLastFree.set(transpiler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        this.thLastFree.remove();
        LinkedList<BabelTranspilerProxy> linkedList = this.freeList;
        synchronized (linkedList) {
            for (BabelTranspilerProxy transpiler : this.freeList) {
                transpiler.getTranspiler().close();
            }
            this.freeList.clear();
        }
        linkedList = this.usingList;
        synchronized (linkedList) {
            for (BabelTranspilerProxy transpiler : this.usingList) {
                transpiler.getTranspiler().close();
            }
            this.usingList.clear();
        }
        this.thLastFree.clearAll();
    }
}

