/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.pool.BabelTranspilerPool;
import kd.sdk.kingscript.transpiler.BabelTranspiler;
import kd.sdk.kingscript.transpiler.TransResult;

final class BabelTranspilerProxy
implements BabelTranspiler {
    private final BabelTranspiler transpiler;
    private final BabelTranspilerPool transpilerPool;
    private final AtomicBoolean closed = new AtomicBoolean();

    BabelTranspilerProxy(BabelTranspiler transpiler, BabelTranspilerPool transpilerPool) {
        this.transpiler = transpiler;
        this.transpilerPool = transpilerPool;
    }

    @Override
    public TransResult trans(KingScriptEngine executeEngine, String ts, boolean debugMode, boolean mappingSource) {
        this.checkClosed();
        return this.transpiler.trans(executeEngine, ts, debugMode, mappingSource);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.transpilerPool.release(this);
        }
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new ScriptException("Transpiler has closed.");
        }
    }

    BabelTranspiler getTranspiler() {
        return this.transpiler;
    }
}

