/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.pool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.annotation.SdkScriptBound;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.engine.ScriptInitializer;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.engine.bindings.ClearConstContext;
import kd.sdk.kingscript.exception.EnginePoolNotReadyException;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Collector;
import kd.sdk.kingscript.pool.BabelTranspilerPool;
import kd.sdk.kingscript.pool.CommonPoolNames;
import kd.sdk.kingscript.pool.KingScriptEnginePoolCleaner;
import kd.sdk.kingscript.pool.KingScriptEngineProxy;
import kd.sdk.kingscript.thread.local.MockThreadLocal;
import kd.sdk.kingscript.transpiler.BabelTranspiler;
import kd.sdk.kingscript.types.function.Handler0;
import org.slf4j.Logger;

@SdkScriptBound(value="@cosmic/bos-script/reflect/Engine")
public final class KingScriptEnginePool {
    private static final Logger logger = Logs.getLogger();
    private static final Map<String, KingScriptEnginePool> runPoolMap = new ConcurrentHashMap<String, KingScriptEnginePool>();
    private static final Map<String, KingScriptEnginePool> debugPoolMap = new ConcurrentHashMap<String, KingScriptEnginePool>();
    private static final long timeout = 101000L;
    private final String name;
    private volatile boolean initializing = false;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private int initSize = 4;
    private int maxSize = 100;
    private final AtomicInteger instanceCount = new AtomicInteger();
    private final LinkedList<KingScriptEngineProxy> freeList = new LinkedList();
    private final LinkedList<KingScriptEngineProxy> usingList = new LinkedList();
    private final MockThreadLocal<KingScriptEngineProxy> thLastFree = new MockThreadLocal();
    private KingScriptEnginePoolCleaner cleaner;
    private final boolean debug;
    private final Handler0 destroyHandler;
    private boolean autoRecreate;
    private long recreateAfterFreeTS = 72720000L;
    private ScriptOptions scriptOptions;
    private BabelTranspilerPool transpilerPool;

    public static KingScriptEnginePool get() {
        return KingScriptEnginePool.get(CommonPoolNames.DEFAULT.name());
    }

    public static KingScriptEnginePool getDebug() {
        return KingScriptEnginePool.getDebug(CommonPoolNames.DEFAULT.name());
    }

    public static KingScriptEnginePool get(String poolName) {
        return runPoolMap.computeIfAbsent(poolName, k -> new KingScriptEnginePool(poolName, false, runPoolMap));
    }

    public static KingScriptEnginePool getDebug(String poolName) {
        return debugPoolMap.computeIfAbsent(poolName, k -> new KingScriptEnginePool(poolName, true, debugPoolMap));
    }

    public static Set<String> getNameSet(boolean debug) {
        return new HashSet<String>(debug ? debugPoolMap.keySet() : runPoolMap.keySet());
    }

    private KingScriptEnginePool(String poolName, boolean debug, Map<String, KingScriptEnginePool> poolMap) {
        this.debug = debug;
        this.destroyHandler = () -> {
            KingScriptEnginePool cfr_ignored_0 = (KingScriptEnginePool)poolMap.remove(poolName);
        };
        this.name = poolName + (debug ? "(debug)" : "");
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void initialize(int activeSize, int maxSize, ScriptInitializer initializer) {
        this.initialize(activeSize, maxSize, initializer, false);
    }

    public void initialize(int activeSize, int maxSize, ScriptInitializer initializer, boolean autoRecreate) {
        this.initialize(activeSize, maxSize, initializer, autoRecreate, this.recreateAfterFreeTS);
    }

    public void initialize(int initSize, int maxSize, ScriptInitializer initializer, boolean autoRecreate, long recreateAfterFreeTS) {
        if (this.initialized.compareAndSet(false, true)) {
            this.destroyed.set(false);
            this.initializing = true;
            if (initSize > maxSize) {
                initSize = maxSize;
            }
            this.initSize = initSize;
            this.maxSize = maxSize;
            this.autoRecreate = autoRecreate;
            this.recreateAfterFreeTS = recreateAfterFreeTS;
            this.scriptOptions = ScriptOptions.createDefault();
            if (initializer != null) {
                initializer.initialize(this.scriptOptions);
            }
            this.scriptOptions.getDebugOptions().setEnabled(this.debug);
            logger.info("Initialize " + this.name + ": {initSize:" + initSize + ", maxSize:" + maxSize + ", autoRecreate:" + autoRecreate + ", recreateAfterFreeTS:" + recreateAfterFreeTS + ", libModules:" + Arrays.asList(this.scriptOptions.getLibModules()) + "}");
            ScriptOptions transpilerScriptOptions = ScriptOptions.createDefault();
            for (LibModule libModule : this.scriptOptions.getLibModules()) {
                transpilerScriptOptions.addModule(libModule);
            }
            this.transpilerPool = new BabelTranspilerPool(BabelTranspiler.create(transpilerScriptOptions));
            for (int i = 0; i < initSize; ++i) {
                KingScriptEngineProxy engine = (KingScriptEngineProxy)this.acquire(false);
                this.onRelease(engine, true);
            }
        } else {
            throw new ScriptException("Engine pool has initialized.");
        }
        this.freeList.addAll(this.usingList);
        this.usingList.clear();
        this.cleaner = new KingScriptEnginePoolCleaner(this);
        this.cleaner.start();
        this.initializing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        while (this.initializing) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.initialized.get() && this.destroyed.compareAndSet(false, true)) {
            logger.info("Destroy " + this.name);
            try {
                this.cleaner.terminate();
                this.cleaner = null;
                LinkedList<KingScriptEngineProxy> linkedList = this.freeList;
                synchronized (linkedList) {
                    for (KingScriptEngineProxy engine : this.freeList) {
                        this.realClose(engine);
                    }
                    this.freeList.clear();
                    this.freeList.notifyAll();
                }
                linkedList = this.usingList;
                synchronized (linkedList) {
                    for (KingScriptEngineProxy engine : this.usingList) {
                        this.realClose(engine);
                    }
                    this.usingList.clear();
                }
                this.transpilerPool.destroy();
                this.instanceCount.set(0);
                this.initialized.set(false);
                this.thLastFree.clearAll();
            }
            finally {
                this.destroyHandler.accept();
                Collector.log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clean() {
        if (!this.destroyed.get()) {
            LinkedList<KingScriptEngineProxy> linkedList = this.freeList;
            synchronized (linkedList) {
                if (this.freeList.size() > this.initSize) {
                    int cleanSize = this.freeList.size() - this.initSize;
                    ArrayList<KingScriptEngineProxy> cleanList = new ArrayList<KingScriptEngineProxy>(cleanSize);
                    for (KingScriptEngineProxy engine : this.freeList) {
                        if (!this.cleaner.canClean(engine)) continue;
                        cleanList.add(engine);
                    }
                    if (!cleanList.isEmpty()) {
                        if (cleanList.size() > cleanSize) {
                            cleanList.sort((o1, o2) -> o1.getLastAccessTime() < o2.getLastAccessTime() ? -1 : 1);
                        }
                        int n = Math.min(cleanSize, cleanList.size());
                        for (int i = 0; i < n; ++i) {
                            KingScriptEngineProxy engine = (KingScriptEngineProxy)cleanList.get(i);
                            this.freeList.remove(engine);
                            this.realClose(engine);
                            this.instanceCount.decrementAndGet();
                        }
                    }
                }
            }
        }
    }

    private void realClose(KingScriptEngineProxy engine) {
        engine.getEngine().close();
    }

    private void checkDestroyed() {
        if (this.destroyed.get()) {
            throw new ScriptException("Engine pool has destroyed.");
        }
    }

    private void checkInitialized() {
        if (!this.initialized.get()) {
            throw new ScriptException("Engine pool has not initialized.");
        }
    }

    public KingScriptEngine acquire() {
        return this.acquire(true);
    }

    private KingScriptEngine acquire(boolean checkInitialized) {
        KingScriptEngineProxy engine;
        while (true) {
            logger.info(this.name + " acquire...");
            if (this.initializing && checkInitialized) {
                logger.info("Waiting for engine pool initialization to complete...");
                int round = 12000;
                while (this.initializing && round-- > 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new ScriptException(e);
                    }
                }
                if (this.initializing) {
                    throw new EnginePoolNotReadyException("Waiting for engine pool initialization timeout(2min), please try later.");
                }
            }
            engine = this.doAcquire();
            if (!this.autoRecreate || !this.shouldRecreate(engine)) break;
            this.release(engine);
        }
        this.onRequire(engine);
        logger.info(this.name + " acquired: " + engine + (this.debug ? " " + engine.getDebugUrl() : ""));
        return engine;
    }

    private void onRequire(KingScriptEngineProxy engine) {
        KingScriptEngineImpl impl = (KingScriptEngineImpl)engine.getEngine();
        impl.setOwnThread(Thread.currentThread());
    }

    private void onRelease(KingScriptEngineProxy engine, boolean initEngine) {
        KingScriptEngineImpl impl = (KingScriptEngineImpl)engine.getEngine();
        ((KingScriptEngineImpl)engine.getEngine()).fireOnClosed();
        if (!initEngine) {
            impl.setTopWrapper(null);
        }
        impl.setOwnThread(null);
        impl.setDebugId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KingScriptEngineProxy doAcquire() {
        LinkedList<KingScriptEngineProxy> linkedList;
        this.checkInitialized();
        this.checkDestroyed();
        KingScriptEngineProxy engine = this.thLastFree.get();
        if (engine != null) {
            linkedList = this.freeList;
            synchronized (linkedList) {
                if (this.freeList.contains(engine)) {
                    this.thLastFree.remove();
                    this.freeList.remove(engine);
                } else {
                    engine = null;
                }
            }
        }
        if (engine == null) {
            linkedList = this.freeList;
            synchronized (linkedList) {
                if (!this.freeList.isEmpty()) {
                    engine = this.freeList.removeFirst();
                }
            }
            int N = 100;
            long perTimeout = 1010L;
            int round = 0;
            while (engine == null) {
                ++round;
                int current = this.instanceCount.get();
                if (current < this.maxSize && this.instanceCount.compareAndSet(current, current + 1)) {
                    try {
                        engine = this.createKingScriptEngineProxy(null);
                    }
                    catch (Exception e) {
                        this.instanceCount.decrementAndGet();
                        throw e;
                    }
                }
                if (engine != null) continue;
                try {
                    engine = this.waitForRelease(1010L);
                    break;
                }
                catch (Exception e) {
                    if (round < 100) continue;
                    throw new ScriptException("No free engine(pool=" + this.maxSize + "): " + this.freeList.size() + "|" + this.usingList.size(), e);
                }
            }
        }
        LinkedList<KingScriptEngineProxy> linkedList2 = this.usingList;
        synchronized (linkedList2) {
            this.usingList.add(engine);
        }
        return engine;
    }

    private KingScriptEngineProxy createKingScriptEngineProxy(KingScriptEngine engine) {
        if (engine == null) {
            engine = KingScriptEngineImpl.create(this.scriptOptions, () -> this.transpilerPool.acquire(), this);
        }
        return new KingScriptEngineProxy((KingScriptEngineImpl)engine, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KingScriptEngineProxy waitForRelease(long timeout) throws Exception {
        LinkedList<KingScriptEngineProxy> linkedList = this.freeList;
        synchronized (linkedList) {
            if (this.freeList.isEmpty()) {
                this.freeList.wait(timeout);
            }
            if (this.freeList.isEmpty()) {
                throw new ScriptException("wait for release timeout: " + timeout + "ms");
            }
            return this.freeList.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(KingScriptEngineProxy engine) {
        logger.info(this.name + " release " + engine);
        this.onRelease(engine, false);
        if (this.destroyed.get()) {
            this.realClose(engine);
            if (this.thLastFree.get() == engine) {
                this.thLastFree.remove();
            }
        } else {
            LinkedList<KingScriptEngineProxy> linkedList = this.usingList;
            synchronized (linkedList) {
                this.usingList.remove(engine);
            }
            boolean createNew = false;
            if (this.autoRecreate && this.shouldRecreate(engine)) {
                this.realClose(engine);
                if (this.instanceCount.get() < this.initSize) {
                    engine = this.createKingScriptEngineProxy(null);
                    createNew = true;
                } else {
                    engine = null;
                    this.instanceCount.decrementAndGet();
                }
            } else {
                this.reset(engine);
                engine = this.createKingScriptEngineProxy(engine.getEngine());
            }
            LinkedList<KingScriptEngineProxy> linkedList2 = this.freeList;
            synchronized (linkedList2) {
                if (engine != null) {
                    if (createNew) {
                        this.freeList.addLast(engine);
                    } else {
                        this.freeList.addFirst(engine);
                    }
                    this.thLastFree.set(engine);
                }
                this.freeList.notifyAll();
            }
        }
    }

    private void reset(KingScriptEngineProxy engine) {
        try (ClearConstContext clearCtx = ClearConstContext.setup();){
            engine.getBindings().clear();
        }
    }

    private boolean shouldRecreate(KingScriptEngineProxy engine) {
        return engine.isForceClose() || System.currentTimeMillis() - engine.getLastAccessTime() > this.recreateAfterFreeTS;
    }

    public String getName() {
        return this.name;
    }

    public int getFreeSize() {
        return this.freeList.size();
    }

    public int getActiveSize() {
        return this.usingList.size();
    }

    public int getTotalSize() {
        return this.usingList.size() + this.freeList.size();
    }

    public int getInitSize() {
        return this.initSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String toString() {
        return this.name;
    }
}

