/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.pool;

import kd.sdk.kingscript.pool.KingScriptEnginePool;
import kd.sdk.kingscript.pool.KingScriptEngineProxy;

final class KingScriptEnginePoolCleaner
extends Thread {
    private static final long interval = 18030000L;
    private volatile boolean terminated = false;
    private Object timer = new Object();
    private KingScriptEnginePool pool;

    KingScriptEnginePoolCleaner(KingScriptEnginePool pool) {
        this.pool = pool;
        this.setName("KingScript-EnginePoolCleaner#" + pool.getName());
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminated) {
            Object object = this.timer;
            synchronized (object) {
                try {
                    this.timer.wait(18030000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (this.terminated) continue;
            this.pool.clean();
        }
    }

    public boolean canClean(KingScriptEngineProxy engine) {
        long ts = System.currentTimeMillis() - engine.getLastAccessTime();
        return ts >= 18030000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminated = true;
        Object object = this.timer;
        synchronized (object) {
            this.timer.notifyAll();
        }
    }
}

